/*
 * Decompiled with CFR 0.152.
 */
package com.auto.framework.operation.commmand;

import com.auto.framework.operation.OpResult;
import com.auto.framework.operation.Operation;
import com.auto.framework.operation.commmand.CommandRequest;
import com.auto.framework.operation.commmand.CommandResult;
import com.auto.framework.operation.commmand.CommandRunner;
import com.auto.framework.operation.commmand.TestCommandExecution;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;

public abstract class AbstractCommandOperation
implements Operation {
    private final CommandRequest request;
    private String installationDir;
    protected CommandResult rResult = null;
    private long commandTimeout = 1000L;
    private Map<String, String> mpEnv = Maps.newHashMap();

    public AbstractCommandOperation(String installationDir, CommandRequest commandRequest) {
        this.installationDir = installationDir;
        this.request = commandRequest;
        this.mpEnv.put("TZ", TimeZone.getDefault().getID());
    }

    public AbstractCommandOperation(String installationDir, CommandRequest commandRequest, Map<String, String> mapEnvVariable) {
        this.installationDir = installationDir;
        this.request = commandRequest;
        this.mpEnv.put("TZ", TimeZone.getDefault().getID());
        this.mpEnv.putAll(mapEnvVariable);
    }

    @Override
    public void execute() {
        CommandRunner commandRunner = new CommandRunner(this.getEnv(), this.getInstallationDir(), this.getCommandTimeout(), this.getCWD());
        commandRunner.runCommand(this.request);
        this.rResult = TestCommandExecution.runCommand(this.request.getCommand(), this.request.getHost());
    }

    @Override
    public OpResult getResult() {
        return this.rResult;
    }

    protected String getCWD() {
        return this.installationDir;
    }

    protected Map<String, String> getEnv() {
        HashMap<String, String> $ = Maps.newHashMap(TestCommandExecution.generateCompEnvironment());
        $.putAll(this.mpEnv);
        return $;
    }

    public CommandResult executeInteractive() {
        return TestCommandExecution.runCommandInteractively(this.request.getCommand(), this.request.getHost(), this.getCommandTimeout());
    }

    public String getInstallationDir() {
        return this.installationDir;
    }

    protected String getHost() {
        return this.request.getHost();
    }

    public void setCommandTimeout(long commandTimeout) {
        this.commandTimeout = commandTimeout;
    }

    public long getCommandTimeout() {
        return this.commandTimeout;
    }

    public void setEnv(String name, String val) {
        this.mpEnv.put(name, val);
    }

    @Override
    public CommandRequest getRequest() {
        return this.request;
    }
}

