/*
 * Decompiled with CFR 0.152.
 */
package com.auto.framework.reporter;

import com.auto.framework.env.RegressionEnvironment;
import com.auto.framework.env.TestEnvironment;
import com.auto.framework.iface.ITestCase;
import com.auto.framework.operation.OpResult;
import com.auto.framework.operation.commmand.CommandRequest;
import com.auto.framework.operation.http.HttpOpRequest;
import com.auto.framework.reporter.ErrorReporter;
import com.auto.framework.reporter.TestFailException;
import com.auto.framework.reporter.appender.TestConsoleAppender;
import com.auto.framework.reporter.appender.TestFileAppender;
import com.auto.framework.reporter.appender.TestOutputStreamAppender;
import com.auto.framework.reporter.appender.startegy.SeparateFilePerCommandStrategy;
import com.auto.framework.reporter.appender.startegy.SingleFileStrategy;
import com.auto.framework.reporter.iface.TestReporterAppender;
import com.auto.framework.utils.FileUtil;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.TTCCLayout;
import org.junit.Assert;

public class TestReporter {
    public static final String OPERATIONS_DIR = "operations";
    public static final String CONTENT_DIR = "content";
    private static final String TEST_LOG = "test.log";
    private static final String STDOUT_APPENDER = "STDOUT_APPENDER";
    private static final String FILE_APPENDER = "FILE_APPENDER";
    private static final List<String> lstIgnoreErrMsg = Lists.newArrayList();
    private static ITestCase testCase = null;
    private static ErrorReporter reporter = null;
    private static boolean fatalOnFail = false;
    private static boolean reconfigLog = true;
    private static Map<String, TestReporterAppender> appenders = Maps.newHashMap();

    public static void redirectOutput(OutputStream oOut) {
        ((TestOutputStreamAppender)appenders.get(STDOUT_APPENDER)).redirectOutput(oOut);
        reconfigLog = true;
    }

    public static void init(ITestCase tTest) {
        testCase = tTest;
        TestReporter.initOutputDir();
        TestReporter.initAppenders();
        TestReporter.TraceLink("INIT: running with base dir ", tTest.getSandBoxDir());
        TestReporter.TRACE("Java home: " + System.getProperty("java.home"));
        TestReporter.initErrorReporter();
    }

    private static void initErrorReporter() {
        reporter = new ErrorReporter(TestReporter.getTestCase(), TestReporter.getOutputDir());
    }

    public static void start() {
        TestReporter.logMessage("START: " + TestReporter.getTestCase().getTestName());
    }

    public static void finish() {
        if (!TestReporter.testFailed() && !TestEnvironment.shouldKeepLog()) {
            FileUtil.delete(TestReporter.getOutputDir());
        } else {
            reporter.dump();
            TestReporter.TraceLink("LOCAL BUGS DIR: ", TestReporter.getOutputDir());
        }
        TestReporter.logMessage("END: " + TestReporter.getTestCase().getTestName());
        TestReporter.logMessage("\u001b[33m\u001b[1mTEST_REPORT:: " + reporter.getPass() + " PASSED " + reporter.getFail() + " FAILED " + reporter.getFatal() + " FATAL" + "\u001b[0m");
        if (TestReporter.testFailed()) {
            if (TestReporter.testFailedNoFatal()) {
                Assert.fail(reporter.getFirstFailure());
            } else {
                if (reporter.getFatalThrowable() instanceof RuntimeException) {
                    throw (RuntimeException)reporter.getFatalThrowable();
                }
                if (reporter.getFatalThrowable() instanceof Error) {
                    throw (Error)reporter.getFatalThrowable();
                }
                throw new RuntimeException(reporter.getFatalThrowable());
            }
        }
    }

    private static boolean shouldKeepLog() {
        return true;
    }

    public static void TRACE(String sMessage) {
        TestReporter.logMessage(sMessage);
    }

    public static void TRACE(Throwable e) {
        String message = e.getMessage() == null ? e.toString() : e.getMessage();
        TestReporter.logMessage("exception caught: " + message, e);
    }

    public static void PASS(String sMessage) {
        TestReporter.logMessage("PASS : " + sMessage);
        reporter.pass();
    }

    public static void FAIL(String sMessage) {
        if (fatalOnFail) {
            TestReporter.FATAL(sMessage);
        } else {
            TestReporter.logMessage("FAIL : " + sMessage, true);
            reporter.fail(sMessage);
        }
    }

    public static void FATAL(Throwable e) {
        if (TestReporter.ignoredErrorMessageExist(e.getMessage())) {
            return;
        }
        String message = e.getMessage() == null ? e.toString() : e.getMessage();
        TestReporter.logMessage("FATAL ERROR: " + message, e);
        TestReporter.fatal(e);
    }

    public static TestFailException FATAL(String sMessage) {
        if (TestReporter.ignoredErrorMessageExist(sMessage)) {
            return null;
        }
        TestFailException t = new TestFailException(sMessage);
        TestReporter.logMessage("FATAL ERROR: " + sMessage, t);
        return TestReporter.fatal(t);
    }

    public static void FAIL(String ... sMessage) {
        TestReporter.FAIL(String.join((CharSequence)"\n", sMessage));
    }

    private static TestFailException fatal(Throwable t) {
        reporter.fatal(t);
        if (TestReporter.getTestCase().isRunning()) {
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            throw new TestFailException(t);
        }
        return null;
    }

    public static void TraceLink(String sMessage, String link) {
        TestReporter.logMessage(sMessage + " file://" + link);
    }

    private static void logMessage(String sMessage) {
        TestReporter.logMessage(sMessage, false);
    }

    private static boolean ignoredErrorMessageExist(String sMessage) {
        for (String errMsg : lstIgnoreErrMsg) {
            if (!StringUtils.contains((CharSequence)sMessage, errMsg)) continue;
            return true;
        }
        return false;
    }

    private static void initAppenders() {
        if (!reconfigLog) {
            return;
        }
        Logger.getRootLogger().removeAllAppenders();
        for (TestReporterAppender appender : appenders.values()) {
            appender.init();
        }
        try {
            BasicConfigurator.configure(new FileAppender((Layout)new TTCCLayout("ISO8601"), TestReporter.getOutputDir() + File.separator + TEST_LOG));
        }
        catch (Exception exception) {
            // empty catch block
        }
        Logger.getRootLogger().setLevel(Level.INFO);
        reconfigLog = false;
    }

    private static ITestCase getTestCase() {
        return testCase;
    }

    private static void initOutputDir() {
        new File(TestReporter.getOutputDir()).mkdirs();
        new File(TestReporter.getOutputDir() + File.separator + OPERATIONS_DIR).mkdir();
        new File(TestReporter.getOutputDir() + File.separator + CONTENT_DIR).mkdir();
    }

    public static String getOutputDir() {
        return TestReporter.getTestCase().getSandBoxDir();
    }

    public static boolean testFailed() {
        return reporter.getFail() + reporter.getFatal() > 0 || reporter.getPass() <= 0;
    }

    public static boolean testFailedNoFatal() {
        return reporter.getFail() > 0 && reporter.getFatal() == 0 && TestReporter.testWithValidResults();
    }

    private static boolean testWithValidResults() {
        return reporter.getFail() + reporter.getFatal() + reporter.getPass() > 0;
    }

    public static void setFatalOnFail() {
        fatalOnFail = true;
    }

    public static void addIgnoredErrorMessage(String errMsg) {
        Preconditions.checkNotNull(errMsg);
        lstIgnoreErrMsg.add(errMsg);
    }

    private static void logMessage(String sMessage, boolean bError) {
        for (TestReporterAppender appender : appenders.values()) {
            appender.logMessage(sMessage, bError);
        }
    }

    private static void logMessage(String sMessage, Throwable t) {
        for (TestReporterAppender appender : appenders.values()) {
            appender.logMessage(sMessage, t);
        }
    }

    public static ErrorReporter getErrorReporter() {
        return reporter;
    }

    public static void disable() {
        appenders.clear();
    }

    public static void traceExecution(CommandRequest cRequest, OpResult rResult) {
        for (TestReporterAppender appender : appenders.values()) {
            appender.traceExecution(cRequest, rResult);
        }
    }

    public static void traceExecution(HttpOpRequest request) {
        for (TestReporterAppender appender : appenders.values()) {
            appender.traceExecution(request);
        }
    }

    public static void load() {
    }

    static {
        BasicConfigurator.configure();
        if (RegressionEnvironment.isRegression()) {
            SingleFileStrategy strategy = new SingleFileStrategy();
            appenders.put(FILE_APPENDER, new TestFileAppender(strategy));
        } else {
            SeparateFilePerCommandStrategy strategy = new SeparateFilePerCommandStrategy();
            appenders.put(FILE_APPENDER, new TestFileAppender(strategy));
            appenders.put(STDOUT_APPENDER, new TestConsoleAppender(strategy));
        }
    }
}

