/*
 * Decompiled with CFR 0.152.
 */
package com.auto.framework.reporter.data;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;

public class TestDataReporterItem {
    private boolean sToBeReported;
    private boolean increaseType;
    private Double sValue;
    private String sKey;
    private int sCount;
    private Double sAvg;
    private Double sMin;
    private Double sMax;

    public TestDataReporterItem(String sKey, Double sValue) {
        this.sKey = sKey.toLowerCase();
        this.sValue = sValue;
        this.sCount = 1;
        this.sAvg = sValue;
        this.sMin = sValue;
        this.sMax = sValue;
    }

    public String getKey() {
        return this.sKey;
    }

    public Double getValue() {
        return this.sValue;
    }

    public boolean shouldBeReported() {
        return this.sToBeReported;
    }

    public void setToBeReported(boolean val) {
        this.sToBeReported = val;
    }

    public boolean getIncreaseType() {
        return this.increaseType;
    }

    public void setIncreaseType(boolean val) {
        this.increaseType = val;
    }

    public void updateItem(double newValue) {
        this.sValue = newValue;
        this.sAvg = (this.sAvg * (double)this.sCount + newValue) / (double)(this.sCount + 1);
        ++this.sCount;
        this.sMax = this.sMax < this.sValue ? this.sValue : this.sMax;
        this.sMin = this.sMin > this.sValue ? this.sValue : this.sMin;
    }

    public List<TestDataReporterItem> getAllSubDataReporterItems() {
        ArrayList<TestDataReporterItem> lstSubData = Lists.newArrayList();
        lstSubData.add(new TestDataReporterItem(this.sKey + ".avg", this.sAvg));
        lstSubData.add(new TestDataReporterItem(this.sKey + ".max", this.sMax));
        lstSubData.add(new TestDataReporterItem(this.sKey + ".min", this.sMin));
        lstSubData.add(this);
        return lstSubData;
    }
}

