/*
 * Decompiled with CFR 0.152.
 */
package com.auto.redis.framework;

import com.auto.framework.AbstractTestComponent;
import com.auto.framework.TestComponentData;
import com.auto.framework.operation.OpResult;
import com.auto.framework.operation.Operation;
import com.auto.redis.operation.RedisFlushDbOperation;
import com.auto.redis.operation.RedisPingOperation;
import com.auto.redis.operation.RedisStartOp;
import com.auto.redis.operation.RedisStopOp;
import org.apache.commons.collections.CollectionUtils;

public class RedisServer
extends AbstractTestComponent {
    protected RedisServer(TestComponentData data) {
        super(data);
    }

    @Override
    protected Operation getStartOperation() {
        return new RedisStartOp(this.getInstallationDir());
    }

    @Override
    protected Operation getStopOperation() {
        return new RedisStopOp(this.getInstallationDir());
    }

    @Override
    public boolean isRunning() {
        OpResult opResult = this.performOperation(new RedisPingOperation(this.getInstallationDir()));
        return CollectionUtils.isNotEmpty(opResult.getStdOut()) && opResult.getStdOut().contains("PONG");
    }

    @Override
    public void clean(boolean bForce) {
        this.performOperation(new RedisFlushDbOperation(this.getInstallationDir()));
    }

    @Override
    public void prepare() {
    }

    public void put(String testKey, String testValue) {
    }

    public String get(String testKey) {
        return null;
    }
}

