/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.common;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.tomakehurst.wiremock.common.Json;
import com.github.tomakehurst.wiremock.common.Strings;
import com.github.tomakehurst.wiremock.common.TextType;
import com.github.tomakehurst.wiremock.common.Xml;
import com.github.tomakehurst.wiremock.http.ContentTypeHeader;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class ContentTypes {
    private static final Map<String, String> COMMON_MIME_TYPES = ImmutableMap.builder().put("image/jpeg", "jpeg").put("image/gif", "gif").put("image/tiff", "tiff").put("image/png", "png").put("image/x-icon", "ico").put("image/svg+xml", "svg").put("audio/x-aiff", "aiff").put("video/x-ms-asf", "asf").put("video/mpeg", "mp2").put("audio/mpeg", "mp3").put("video/quicktime", "mov").put("application/pdf", "pdf").build();
    public static final List<String> TEXT_FILE_EXTENSIONS = Arrays.asList("txt", "json", "xml", "html", "htm", "yaml", "csv");
    public static final List<String> TEXT_MIME_TYPE_PATTERNS = Arrays.asList(".*text.*", ".*json.*", ".*xml.*", ".*html.*", ".*yaml.*", ".*csv.*", ".*x-www-form-urlencoded.*");

    public static String determineFileExtension(String url, ContentTypeHeader contentTypeHeader, byte[] responseBody) {
        String path;
        String lastPathSegment;
        if (contentTypeHeader.isPresent()) {
            if (contentTypeHeader.mimeTypePart().contains("json")) {
                return "json";
            }
            if (contentTypeHeader.mimeTypePart().contains("xml")) {
                return "xml";
            }
            if (contentTypeHeader.mimeTypePart().contains("text")) {
                return "txt";
            }
            String extension = COMMON_MIME_TYPES.get(contentTypeHeader.mimeTypePart());
            if (extension != null) {
                return extension;
            }
        }
        if ((lastPathSegment = StringUtils.substringAfterLast(path = URI.create(url).getPath(), "/")).indexOf(46) != -1) {
            return StringUtils.substringAfterLast(lastPathSegment, ".");
        }
        return ContentTypes.determineTextFileExtension(Strings.stringFromBytes(responseBody, contentTypeHeader.charset()));
    }

    public static TextType determineTextType(String content) {
        try {
            Json.read(content, JsonNode.class);
            return TextType.JSON;
        }
        catch (Exception e) {
            try {
                Xml.read(content);
                return TextType.XML;
            }
            catch (Exception e1) {
                return TextType.PLAIN_TEXT;
            }
        }
    }

    public static String determineTextFileExtension(String content) {
        TextType textType = ContentTypes.determineTextType(content);
        switch (textType) {
            case JSON: {
                return "json";
            }
            case XML: {
                return "xml";
            }
        }
        return "txt";
    }

    public static boolean determineIsTextFromExtension(String extension) {
        return TEXT_FILE_EXTENSIONS.contains(extension);
    }

    public static boolean determineIsTextFromMimeType(final String mimeType) {
        return Iterables.any(TEXT_MIME_TYPE_PATTERNS, new Predicate<String>(){

            @Override
            public boolean apply(String pattern) {
                return mimeType != null && mimeType.matches(pattern);
            }
        });
    }

    public static boolean determineIsText(String extension, String mimeType) {
        return ContentTypes.determineIsTextFromExtension(extension) || ContentTypes.determineIsTextFromMimeType(mimeType);
    }
}

