/*
 * Decompiled with CFR 0.152.
 */
package dnl.utils.text.table.csv;

import au.com.bytecode.opencsv.CSVReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class CsvTableModel
extends AbstractTableModel {
    private String[] columnNames;
    private List<String[]> lines = new ArrayList<String[]>();

    public CsvTableModel(File csvFile) throws IOException {
        this(new FileReader(csvFile));
    }

    public CsvTableModel(String csvString) throws IOException {
        this(new StringReader(csvString));
    }

    public CsvTableModel(Reader reader) throws IOException {
        try (CSVReader csvReader = new CSVReader(reader);){
            String[] line = null;
            boolean first = true;
            while ((line = csvReader.readNext()) != null) {
                if (first) {
                    this.columnNames = line;
                    first = false;
                    continue;
                }
                this.lines.add(line);
            }
        }
    }

    @Override
    public String getColumnName(int column) {
        return this.columnNames[column];
    }

    @Override
    public int getRowCount() {
        return this.lines.size();
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        String[] line = this.lines.get(rowIndex);
        return line[columnIndex];
    }
}

