/*
 * Decompiled with CFR 0.152.
 */
package org.xmlunit.placeholder;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import org.w3c.dom.Node;
import org.xmlunit.diff.Comparison;
import org.xmlunit.diff.ComparisonResult;
import org.xmlunit.diff.ComparisonType;
import org.xmlunit.diff.DifferenceEvaluator;
import org.xmlunit.placeholder.PlaceholderHandler;
import org.xmlunit.util.Nodes;

public class PlaceholderDifferenceEvaluator
implements DifferenceEvaluator {
    public static final String PLACEHOLDER_DEFAULT_OPENING_DELIMITER_REGEX = Pattern.quote("${");
    public static final String PLACEHOLDER_DEFAULT_CLOSING_DELIMITER_REGEX = Pattern.quote("}");
    private static final String PLACEHOLDER_PREFIX_REGEX = Pattern.quote("xmlunit.");
    private static final Map<String, PlaceholderHandler> KNOWN_HANDLERS;
    private final Pattern placeholderRegex;

    public PlaceholderDifferenceEvaluator() {
        this(null, null);
    }

    public PlaceholderDifferenceEvaluator(String placeholderOpeningDelimiterRegex, String placeholderClosingDelimiterRegex) {
        if (placeholderOpeningDelimiterRegex == null || placeholderOpeningDelimiterRegex.trim().length() == 0) {
            placeholderOpeningDelimiterRegex = PLACEHOLDER_DEFAULT_OPENING_DELIMITER_REGEX;
        }
        if (placeholderClosingDelimiterRegex == null || placeholderClosingDelimiterRegex.trim().length() == 0) {
            placeholderClosingDelimiterRegex = PLACEHOLDER_DEFAULT_CLOSING_DELIMITER_REGEX;
        }
        this.placeholderRegex = Pattern.compile("(\\s*" + placeholderOpeningDelimiterRegex + "\\s*" + PLACEHOLDER_PREFIX_REGEX + "(.+)\\s*" + placeholderClosingDelimiterRegex + "\\s*)");
    }

    @Override
    public ComparisonResult evaluate(Comparison comparison, ComparisonResult outcome) {
        if (outcome == ComparisonResult.EQUAL) {
            return outcome;
        }
        Comparison.Detail controlDetails = comparison.getControlDetails();
        Node controlTarget = controlDetails.getTarget();
        Comparison.Detail testDetails = comparison.getTestDetails();
        Node testTarget = testDetails.getTarget();
        if (comparison.getType() == ComparisonType.TEXT_VALUE) {
            return this.evaluateConsideringPlaceholders((String)controlDetails.getValue(), (String)testDetails.getValue(), outcome);
        }
        if (this.isMissingTextNodeDifference(comparison)) {
            return this.evaluateMissingTextNodeConsideringPlaceholders(comparison, outcome);
        }
        if (this.isTextCDATAMismatch(comparison)) {
            return this.evaluateConsideringPlaceholders(controlTarget.getNodeValue(), testTarget.getNodeValue(), outcome);
        }
        if (comparison.getType() == ComparisonType.ATTR_VALUE) {
            return this.evaluateConsideringPlaceholders((String)controlDetails.getValue(), (String)testDetails.getValue(), outcome);
        }
        if (this.isMissingAttributeDifference(comparison)) {
            return this.evaluateMissingAttributeConsideringPlaceholders(comparison, outcome);
        }
        return outcome;
    }

    private boolean isMissingTextNodeDifference(Comparison comparison) {
        return this.controlHasOneTextChildAndTestHasNone(comparison) || this.cantFindControlTextChildInTest(comparison);
    }

    private boolean controlHasOneTextChildAndTestHasNone(Comparison comparison) {
        Comparison.Detail controlDetails = comparison.getControlDetails();
        Node controlTarget = controlDetails.getTarget();
        Comparison.Detail testDetails = comparison.getTestDetails();
        return comparison.getType() == ComparisonType.CHILD_NODELIST_LENGTH && Integer.valueOf(1).equals(controlDetails.getValue()) && Integer.valueOf(0).equals(testDetails.getValue()) && this.isTextLikeNode(controlTarget.getFirstChild());
    }

    private boolean cantFindControlTextChildInTest(Comparison comparison) {
        Node controlTarget = comparison.getControlDetails().getTarget();
        return comparison.getType() == ComparisonType.CHILD_LOOKUP && controlTarget != null && this.isTextLikeNode(controlTarget);
    }

    private ComparisonResult evaluateMissingTextNodeConsideringPlaceholders(Comparison comparison, ComparisonResult outcome) {
        Node controlTarget = comparison.getControlDetails().getTarget();
        String value = this.controlHasOneTextChildAndTestHasNone(comparison) ? controlTarget.getFirstChild().getNodeValue() : controlTarget.getNodeValue();
        return this.evaluateConsideringPlaceholders(value, null, outcome);
    }

    private boolean isTextCDATAMismatch(Comparison comparison) {
        return comparison.getType() == ComparisonType.NODE_TYPE && this.isTextLikeNode(comparison.getControlDetails().getTarget()) && this.isTextLikeNode(comparison.getTestDetails().getTarget());
    }

    private boolean isTextLikeNode(Node node) {
        short nodeType = node.getNodeType();
        return nodeType == 3 || nodeType == 4;
    }

    private boolean isMissingAttributeDifference(Comparison comparison) {
        return comparison.getType() == ComparisonType.ELEMENT_NUM_ATTRIBUTES || comparison.getType() == ComparisonType.ATTR_NAME_LOOKUP && comparison.getControlDetails().getTarget() != null && comparison.getControlDetails().getValue() != null;
    }

    private ComparisonResult evaluateMissingAttributeConsideringPlaceholders(Comparison comparison, ComparisonResult outcome) {
        if (comparison.getType() == ComparisonType.ELEMENT_NUM_ATTRIBUTES) {
            return this.evaluateAttributeListLengthConsideringPlaceholders(comparison, outcome);
        }
        String controlAttrValue = Nodes.getAttributes(comparison.getControlDetails().getTarget()).get((QName)comparison.getControlDetails().getValue());
        return this.evaluateConsideringPlaceholders(controlAttrValue, null, outcome);
    }

    private ComparisonResult evaluateAttributeListLengthConsideringPlaceholders(Comparison comparison, ComparisonResult outcome) {
        Map<QName, String> controlAttrs = Nodes.getAttributes(comparison.getControlDetails().getTarget());
        Map<QName, String> testAttrs = Nodes.getAttributes(comparison.getTestDetails().getTarget());
        int cAttrsMatched = 0;
        for (Map.Entry<QName, String> cAttr : controlAttrs.entrySet()) {
            String testValue = testAttrs.get(cAttr.getKey());
            if (testValue == null) {
                ComparisonResult o = this.evaluateConsideringPlaceholders(cAttr.getValue(), null, outcome);
                if (o == ComparisonResult.EQUAL) continue;
                return outcome;
            }
            ++cAttrsMatched;
        }
        if (cAttrsMatched != testAttrs.size()) {
            return outcome;
        }
        return ComparisonResult.EQUAL;
    }

    private ComparisonResult evaluateConsideringPlaceholders(String controlText, String testText, ComparisonResult outcome) {
        String keyword;
        Matcher m3 = this.placeholderRegex.matcher(controlText);
        if (m3.find() && this.isKnown(keyword = m3.group(2).trim())) {
            if (!m3.group(1).trim().equals(controlText.trim())) {
                throw new RuntimeException("The placeholder must exclusively occupy the text node.");
            }
            return this.evaluate(keyword, testText);
        }
        return outcome;
    }

    private boolean isKnown(String keyword) {
        return KNOWN_HANDLERS.containsKey(keyword);
    }

    private ComparisonResult evaluate(String keyword, String testText) {
        return KNOWN_HANDLERS.get(keyword).evaluate(testText);
    }

    static {
        HashMap<String, PlaceholderHandler> m3 = new HashMap<String, PlaceholderHandler>();
        for (PlaceholderHandler h2 : ServiceLoader.load(PlaceholderHandler.class)) {
            m3.put(h2.getKeyword(), h2);
        }
        KNOWN_HANDLERS = Collections.unmodifiableMap(m3);
    }
}

