/*
 * Decompiled with CFR 0.152.
 */
package com.auto.framework.runner.console.progressbar;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.time.Duration;
import org.jline.terminal.Terminal;
import org.jline.terminal.TerminalBuilder;

class Util {
    private static int defaultTerminalWidth = 160;

    Util() {
    }

    static String repeat(char c, int n) {
        if (n <= 0) {
            return "";
        }
        char[] s2 = new char[n];
        for (int i = 0; i < n; ++i) {
            s2[i] = c;
        }
        return new String(s2);
    }

    static String formatDuration(Duration d) {
        long s2 = d.getSeconds();
        return String.format("%02d:%02d", s2 % 3600L / 60L, s2 % 60L);
    }

    static long getInputStreamSize(InputStream is) {
        try {
            if (is instanceof FileInputStream) {
                return ((FileInputStream)is).getChannel().size();
            }
        }
        catch (IOException e) {
            return -1L;
        }
        return -1L;
    }

    static Terminal getTerminal() {
        Terminal terminal = null;
        try {
            terminal = TerminalBuilder.builder().dumb(true).build();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return terminal;
    }

    static int getTerminalWidth(Terminal terminal) {
        if (terminal != null && terminal.getWidth() >= 10) {
            return terminal.getWidth();
        }
        return defaultTerminalWidth;
    }

    static int getTerminalWidth() {
        Terminal terminal = Util.getTerminal();
        int width = Util.getTerminalWidth(terminal);
        try {
            if (terminal != null) {
                terminal.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return width;
    }
}

