/*
 * Decompiled with CFR 0.152.
 */
package com.auto.framework.runner.mail;

import java.util.Collection;
import java.util.List;
import java.util.Properties;
import javax.activation.DataHandler;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.util.ByteArrayDataSource;
import org.apache.commons.lang.StringUtils;

public class MailSender {
    private Session session = null;
    private Properties props = new Properties();
    private String user = "";
    private String pwd = "";

    public MailSender(String host, String port, String user, String password) {
        this.user = StringUtils.isEmpty(user) ? "" : user;
        this.pwd = StringUtils.isEmpty(user) ? "" : password;
        this.props.put("mail.smtp.host", host);
        this.props.put("mail.smtp.port", port);
        if (!StringUtils.isBlank(user)) {
            this.props.put("mail.smtp.auth", "true");
        }
        this.props.put("mail.smtp.socketFactory.port", port);
        this.props.put("mail.smtp.socketFactory.fallback", "true");
        this.session = Session.getDefaultInstance(this.props);
    }

    public void sendEmail(String to, String from, String subjectMessage, String bodyMessage, String fromName, String contentType) throws MessagingException {
        MimeMessage mimeMessage = new MimeMessage(this.session);
        if (contentType != null) {
            mimeMessage.setContent(bodyMessage, contentType);
        } else {
            mimeMessage.setText(bodyMessage);
        }
        mimeMessage.setSubject(subjectMessage);
        if (fromName != null) {
            from = fromName + "<" + (String)from + ">";
        }
        mimeMessage.setFrom(new InternetAddress((String)from));
        if (to.indexOf(44) >= 0) {
            for (String nextTo : to.split(",")) {
                mimeMessage.addRecipient(Message.RecipientType.TO, new InternetAddress(nextTo));
            }
        } else {
            mimeMessage.addRecipient(Message.RecipientType.TO, new InternetAddress(to));
        }
        mimeMessage.saveChanges();
        this.send(mimeMessage);
    }

    public void sendEmail(String email, String from, String subjectMessage, String bodyMessage) throws MessagingException {
        this.sendEmail(email, from, subjectMessage, bodyMessage, null, null);
    }

    private void send(Message message) throws MessagingException {
        Transport transport = this.session.getTransport("smtp");
        if (!StringUtils.isBlank(this.user)) {
            transport.connect(this.user, this.pwd);
        } else {
            transport.connect();
        }
        transport.sendMessage(message, message.getAllRecipients());
        transport.close();
    }

    public void sendEmail(Collection<String> toList, Collection<String> ccList, Collection<String> bccList, String from, String subjectMessage, String bodyMessage) throws MessagingException {
        this.sendEmail(toList, ccList, bccList, from, subjectMessage, bodyMessage, null);
    }

    public void sendEmail(Collection<String> toList, Collection<String> ccList, Collection<String> bccList, String from, String subjectMessage, String bodyMessage, byte[] file, String fileName, String contentType) throws MessagingException {
        MimeMessage mimeMessage = new MimeMessage(this.session);
        ((Message)mimeMessage).setSubject(subjectMessage);
        ((Message)mimeMessage).setFrom(new InternetAddress(from));
        if (toList != null) {
            for (String to : toList) {
                mimeMessage.addRecipient(Message.RecipientType.TO, new InternetAddress(to));
            }
        }
        if (ccList != null) {
            for (String cc : ccList) {
                mimeMessage.addRecipient(Message.RecipientType.CC, new InternetAddress(cc));
            }
        }
        if (bccList != null) {
            for (String bcc : bccList) {
                mimeMessage.addRecipient(Message.RecipientType.BCC, new InternetAddress(bcc));
            }
        }
        MimeMultipart multipart = new MimeMultipart();
        MimeBodyPart bodyMessagePart = new MimeBodyPart();
        bodyMessagePart.setText(bodyMessage);
        bodyMessagePart.setContent(bodyMessage, "text/html");
        MimeBodyPart attachFilePart = new MimeBodyPart();
        attachFilePart.setDataHandler(new DataHandler(new ByteArrayDataSource(file, contentType)));
        attachFilePart.setFileName(fileName);
        attachFilePart.setDisposition("attachment");
        multipart.addBodyPart(attachFilePart);
        multipart.addBodyPart(bodyMessagePart);
        mimeMessage.setContent(multipart);
        ((Message)mimeMessage).saveChanges();
        this.send(mimeMessage);
    }

    public void sendEmail(Collection<String> toList, Collection<String> ccList, Collection<String> bccList, String from, String subjectMessage, String bodyMessage, byte[][] files, List<String> fileNames, List<String> contentTypes) throws MessagingException {
        MimeMessage mimeMessage = new MimeMessage(this.session);
        ((Message)mimeMessage).setSubject(subjectMessage);
        ((Message)mimeMessage).setFrom(new InternetAddress(from));
        if (toList != null) {
            for (String to : toList) {
                mimeMessage.addRecipient(Message.RecipientType.TO, new InternetAddress(to));
            }
        }
        if (ccList != null) {
            for (String cc : ccList) {
                mimeMessage.addRecipient(Message.RecipientType.CC, new InternetAddress(cc));
            }
        }
        if (bccList != null) {
            for (String bcc : bccList) {
                mimeMessage.addRecipient(Message.RecipientType.BCC, new InternetAddress(bcc));
            }
        }
        MimeMultipart multipart = new MimeMultipart();
        MimeBodyPart bodyMessagePart = new MimeBodyPart();
        bodyMessagePart.setText(bodyMessage);
        bodyMessagePart.setContent(bodyMessage, "text/html");
        for (int i = 0; i < fileNames.size(); ++i) {
            MimeBodyPart attachFilePart = new MimeBodyPart();
            attachFilePart.setDataHandler(new DataHandler(new ByteArrayDataSource(files[i], contentTypes.get(i))));
            attachFilePart.setFileName(fileNames.get(i));
            attachFilePart.setDisposition("attachment");
            multipart.addBodyPart(attachFilePart);
        }
        multipart.addBodyPart(bodyMessagePart);
        mimeMessage.setContent(multipart);
        ((Message)mimeMessage).saveChanges();
        this.send(mimeMessage);
    }

    public void sendEmail(Collection<String> toList, Collection<String> ccList, Collection<String> bccList, String from, String subjectMessage, String bodyMessage, String contentType) throws MessagingException {
        MimeMessage mimeMessage = new MimeMessage(this.session);
        if (contentType != null) {
            mimeMessage.setContent(bodyMessage, contentType);
        } else {
            mimeMessage.setText(bodyMessage);
        }
        mimeMessage.setSubject(subjectMessage);
        mimeMessage.setFrom(new InternetAddress(from));
        if (toList != null) {
            for (String to : toList) {
                mimeMessage.addRecipient(Message.RecipientType.TO, new InternetAddress(to));
            }
        }
        if (ccList != null) {
            for (String cc : ccList) {
                mimeMessage.addRecipient(Message.RecipientType.CC, new InternetAddress(cc));
            }
        }
        if (bccList != null) {
            for (String bcc : bccList) {
                mimeMessage.addRecipient(Message.RecipientType.BCC, new InternetAddress(bcc));
            }
        }
        mimeMessage.saveChanges();
        this.send(mimeMessage);
    }
}

