/*
 * Decompiled with CFR 0.152.
 */
package com.auto.framework.runner.report;

import com.auto.framework.env.TestEnvironment;
import com.auto.framework.reporter.data.TestDataReporterItem;
import com.auto.framework.runner.data.ExecutionResult;
import com.auto.framework.runner.data.ExecutionSummary;
import com.auto.framework.runner.job.TestJobResult;
import com.auto.framework.runner.mail.MailConfig;
import com.auto.framework.runner.mail.MailSender;
import com.auto.framework.runner.mail.MailTemplateBuilder;
import com.auto.framework.runner.report.AbstractReporter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.mail.MessagingException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class MailReporter
extends AbstractReporter {
    private List<MailTemplateBuilder.TableBuilder> tableBuilder;
    boolean isMailSent = false;
    private MailConfig mailConfig;

    public MailReporter(MailConfig mailConfig, List<MailTemplateBuilder.TableBuilder> tableBuilders) {
        this.mailConfig = mailConfig;
        this.tableBuilder = tableBuilders;
    }

    public MailReporter(MailConfig mailConfig) {
        this.mailConfig = mailConfig;
    }

    @Override
    public void accept(ExecutionResult result) {
        try {
            if (this.mailConfig.getEnabled()) {
                String sHtml = this.buildTemplate(result);
                this.isMailSent = this.sendReport(sHtml);
            } else {
                this.isMailSent = false;
            }
        }
        catch (Exception e) {
            this.isMailSent = true;
        }
    }

    private String buildTemplate(ExecutionResult result) {
        MailTemplateBuilder mailTemplateBuilder = new MailTemplateBuilder().withTable(this.buildSummaryTable(result.getSummary())).withTable(this.buildDetailReport(result.getJobResults()));
        if (null != this.tableBuilder) {
            this.tableBuilder.forEach(builder -> mailTemplateBuilder.withTable(builder.build()));
        }
        return mailTemplateBuilder.build();
    }

    private String buildDetailReport(List<TestJobResult> jobResults) {
        String[] dynamicColumns = (String[])jobResults.stream().flatMap(jobResult -> jobResult.getCustomTestData().stream()).filter(TestDataReporterItem::shouldBeReported).map(item -> StringUtils.capitalize(item.getKey())).toArray(String[]::new);
        String[] headerColumns = (String[])Stream.of(DETAIL_COLUMN_NAMES, dynamicColumns).flatMap(Arrays::stream).toArray(String[]::new);
        ArrayList<String[]> rows = new ArrayList<String[]>();
        for (TestJobResult result : jobResults) {
            String[] row = new String[headerColumns.length];
            for (int i = 0; i < headerColumns.length; ++i) {
                String columnName = headerColumns[i];
                if (columnName.equals("Class")) {
                    row[i] = result.getClassName();
                    continue;
                }
                if (columnName.equals("Test")) {
                    row[i] = result.getName();
                    continue;
                }
                if (columnName.equals("Status")) {
                    row[i] = result.isPass() ? "Pass" : "Fail";
                    continue;
                }
                if (columnName.equals("Message")) {
                    row[i] = result.getErrorMessage();
                    continue;
                }
                if (!CollectionUtils.isNotEmpty(result.getCustomTestData())) continue;
                Optional<TestDataReporterItem> any = result.getCustomTestData().stream().filter(a -> columnName.equalsIgnoreCase(a.getKey())).findAny();
                row[i] = any.isPresent() ? any.get().getValue().toString() : "";
            }
            rows.add(row);
        }
        return new MailTemplateBuilder.TableBuilder().withTitle("Regression detail report").withHeaders(headerColumns).withRows(rows).build();
    }

    private String buildSummaryTable(ExecutionSummary summary) {
        String[] strings = new String[]{String.valueOf(summary.getPass()), String.valueOf(summary.getFatal()), String.valueOf(summary.getFail())};
        ArrayList<String[]> rows = new ArrayList<String[]>();
        rows.add(strings);
        return new MailTemplateBuilder.TableBuilder().withTitle("Regression summary").withHeaders(SUMMARY_COLUMN_NAMES).withRows(rows).build();
    }

    private boolean sendReport(String sMailTemplate) throws MessagingException {
        String host = this.mailConfig.getHost();
        if (StringUtils.isEmpty(host)) {
            return false;
        }
        String port = this.mailConfig.getPort();
        if (StringUtils.isEmpty(port)) {
            return false;
        }
        String to = this.mailConfig.getTo();
        if (StringUtils.isEmpty(to)) {
            return false;
        }
        String from = this.mailConfig.getFrom();
        if (StringUtils.isEmpty(from)) {
            return false;
        }
        String fromName = this.mailConfig.getFromName();
        if (StringUtils.isEmpty(fromName)) {
            fromName = "Priytam Jee Pandey";
        }
        String user = this.mailConfig.getUser();
        String password = this.mailConfig.getFrom();
        String subjectMessage = "(Automated mail) " + TestEnvironment.getCurrentApplication() + " automation report";
        MailSender mailSender = new MailSender(host, port, user, password);
        mailSender.sendEmail(to, from, subjectMessage, sMailTemplate, fromName, "text/html");
        return true;
    }

    public boolean isMailSent() {
        return this.isMailSent;
    }
}

