/*
 * Decompiled with CFR 0.152.
 */
package com.auto.framework.runner.testlist;

import com.auto.framework.rules.parameterized.ParameterizedTest;
import com.auto.framework.rules.parameterized.TestParametersManager;
import com.auto.framework.runner.testlist.TestListBuilder;
import com.auto.framework.runner.testlist.TestListBuilderHandler;
import com.google.common.collect.Lists;
import java.lang.annotation.Annotation;
import java.lang.invoke.CallSite;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.junit.Ignore;
import org.junit.Test;

public class TestListBuilderImpl
implements TestListBuilder {
    public static final String INTERNAL_CLASSES_PREFIX = "com.auto";

    @Override
    public Collection<String> build(String sClassPath, String sClassPrefix) {
        String classesPrefix = StringUtils.isNotBlank(sClassPrefix) ? sClassPrefix : INTERNAL_CLASSES_PREFIX;
        String testsDir = "all";
        ArrayList<String> colAllTests = new ArrayList<String>();
        Collection<String> colClasses = new TestListBuilderHandler(classesPrefix).getAllClasses(testsDir, sClassPath);
        for (String sClass : colClasses) {
            Collection<String> colTests = this.getTestsInClass(sClass);
            colAllTests.addAll(colTests);
        }
        return colAllTests;
    }

    @Override
    public Collection<String> build(String sClassPrefix) {
        String classesPrefix = StringUtils.isNotBlank(sClassPrefix) ? sClassPrefix : INTERNAL_CLASSES_PREFIX;
        Set<Method> methods = new TestListBuilderHandler(classesPrefix).getMothods();
        return this.getTestInMethods(methods.toArray(new Method[0]));
    }

    @Override
    public String getXmlString(Collection<String> colAllTests) {
        StringBuilder rResponse = new StringBuilder();
        this.addOutput(rResponse, "<tests>\n");
        for (String sTest : colAllTests) {
            this.addOutput(rResponse, this.buildTestXML(sTest) + "\n");
        }
        this.addOutput(rResponse, "</tests>\n");
        return rResponse.toString();
    }

    private void addOutput(StringBuilder rResponse, String s2) {
        rResponse.append(s2);
    }

    private Collection<String> getTestsInClass(String sClass) {
        Class<?> clazz;
        ArrayList<String> colTests = new ArrayList<String>();
        try {
            clazz = Class.forName(sClass);
        }
        catch (Throwable e) {
            return colTests;
        }
        if (!this.testsAllowed(clazz.getPackage())) {
            return colTests;
        }
        if (!this.testsAllowed(clazz)) {
            return colTests;
        }
        Method[] methods = clazz.getDeclaredMethods();
        colTests.addAll(this.getTestInMethods(methods));
        return colTests;
    }

    private Collection<String> getTestInMethods(Method[] methods) {
        ArrayList<String> tests = Lists.newArrayList();
        for (int i = 0; i < methods.length; ++i) {
            Method method = methods[i];
            if (!method.isAnnotationPresent(Test.class) || !this.testsAllowed(method)) continue;
            Class<?> clazz = method.getDeclaringClass();
            String sTestName = clazz.getName() + "." + method.getName();
            ArrayList<CallSite> colTestNames = Lists.newArrayList();
            if (this.isParameterizedTest(clazz, method)) {
                for (int j = 1; j <= this.generateNumberOfPermutations(clazz, method); ++j) {
                    colTestNames.add((CallSite)((Object)(sTestName + "[" + j + "]")));
                }
            } else {
                colTestNames.add((CallSite)((Object)sTestName));
            }
            tests.addAll(colTestNames);
        }
        return tests;
    }

    private int generateNumberOfPermutations(Class clazz, Method method) {
        try {
            Object tTest = clazz.newInstance();
            TestParametersManager.init(tTest);
            return TestParametersManager.getNumOfIterations();
        }
        catch (Exception e) {
            return -1;
        }
    }

    private boolean isParameterizedTest(Class clazz, Method method) {
        return this.matchesAnnotation(clazz, method, ParameterizedTest.class);
    }

    private String buildTestXML(String sTestName) {
        String sOutput = "<test name='" + sTestName + "'>\n";
        sOutput = sOutput + "</test>";
        return sOutput;
    }

    private boolean testsAllowed(AnnotatedElement eElement) {
        return !eElement.isAnnotationPresent(Ignore.class);
    }

    private boolean matchesAnnotation(Class clazz, Method mMethod, Class<? extends Annotation> annotation) {
        return mMethod.isAnnotationPresent(annotation) || clazz.isAnnotationPresent(annotation) || clazz.getPackage().isAnnotationPresent(annotation);
    }
}

