/*
 * Decompiled with CFR 0.152.
 */
package com.github.tomakehurst.wiremock.http;

import com.github.tomakehurst.wiremock.common.HttpClientUtils;
import com.github.tomakehurst.wiremock.common.KeyStoreSettings;
import com.github.tomakehurst.wiremock.common.ProxySettings;
import com.github.tomakehurst.wiremock.global.GlobalSettingsHolder;
import com.github.tomakehurst.wiremock.http.ContentTypeHeader;
import com.github.tomakehurst.wiremock.http.HttpClientFactory;
import com.github.tomakehurst.wiremock.http.HttpHeader;
import com.github.tomakehurst.wiremock.http.HttpHeaders;
import com.github.tomakehurst.wiremock.http.Request;
import com.github.tomakehurst.wiremock.http.RequestMethod;
import com.github.tomakehurst.wiremock.http.Response;
import com.github.tomakehurst.wiremock.http.ResponseDefinition;
import com.github.tomakehurst.wiremock.http.ResponseRenderer;
import com.github.tomakehurst.wiremock.stubbing.ServeEvent;
import com.google.common.collect.ImmutableList;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.LinkedList;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.GzipCompressingEntity;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.InputStreamEntity;

public class ProxyResponseRenderer
implements ResponseRenderer {
    private static final int MINUTES = 60000;
    private static final String TRANSFER_ENCODING = "transfer-encoding";
    private static final String CONTENT_ENCODING = "content-encoding";
    private static final String CONTENT_LENGTH = "content-length";
    private static final String HOST_HEADER = "host";
    public static final ImmutableList<String> FORBIDDEN_HEADERS = ImmutableList.of("content-length", "transfer-encoding", "connection");
    private final HttpClient client;
    private final boolean preserveHostHeader;
    private final String hostHeaderValue;
    private final GlobalSettingsHolder globalSettingsHolder;

    public ProxyResponseRenderer(ProxySettings proxySettings, KeyStoreSettings trustStoreSettings, boolean preserveHostHeader, String hostHeaderValue, GlobalSettingsHolder globalSettingsHolder) {
        this.globalSettingsHolder = globalSettingsHolder;
        this.client = HttpClientFactory.createClient(1000, 300000, proxySettings, trustStoreSettings);
        this.preserveHostHeader = preserveHostHeader;
        this.hostHeaderValue = hostHeaderValue;
    }

    @Override
    public Response render(ServeEvent serveEvent) {
        ResponseDefinition responseDefinition = serveEvent.getResponseDefinition();
        HttpUriRequest httpRequest = ProxyResponseRenderer.getHttpRequestFor(responseDefinition);
        this.addRequestHeaders(httpRequest, responseDefinition);
        try {
            ProxyResponseRenderer.addBodyIfPostPutOrPatch(httpRequest, responseDefinition);
            HttpResponse httpResponse = this.client.execute(httpRequest);
            return Response.response().status(httpResponse.getStatusLine().getStatusCode()).headers(this.headersFrom(httpResponse, responseDefinition)).body(HttpClientUtils.getEntityAsByteArrayAndCloseStream(httpResponse)).fromProxy(true).configureDelay(this.globalSettingsHolder.get().getFixedDelay(), this.globalSettingsHolder.get().getDelayDistribution(), responseDefinition.getFixedDelayMilliseconds(), responseDefinition.getDelayDistribution()).chunkedDribbleDelay(responseDefinition.getChunkedDribbleDelay()).build();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private HttpHeaders headersFrom(HttpResponse httpResponse, ResponseDefinition responseDefinition) {
        LinkedList<HttpHeader> httpHeaders = new LinkedList<HttpHeader>();
        for (Header header : httpResponse.getAllHeaders()) {
            if (!ProxyResponseRenderer.responseHeaderShouldBeTransferred(header.getName())) continue;
            httpHeaders.add(new HttpHeader(header.getName(), header.getValue()));
        }
        if (responseDefinition.getHeaders() != null) {
            httpHeaders.addAll(responseDefinition.getHeaders().all());
        }
        return new HttpHeaders(httpHeaders);
    }

    public static HttpUriRequest getHttpRequestFor(ResponseDefinition response) {
        RequestMethod method = response.getOriginalRequest().getMethod();
        String url = response.getProxyUrl();
        return HttpClientFactory.getHttpRequestFor(method, url);
    }

    private void addRequestHeaders(HttpRequest httpRequest, ResponseDefinition response) {
        Request originalRequest = response.getOriginalRequest();
        for (String key : originalRequest.getAllHeaderKeys()) {
            if (!ProxyResponseRenderer.requestHeaderShouldBeTransferred(key)) continue;
            if (!HOST_HEADER.equalsIgnoreCase(key) || this.preserveHostHeader) {
                List<String> values = originalRequest.header(key).values();
                for (String value : values) {
                    httpRequest.addHeader(key, value);
                }
                continue;
            }
            if (this.hostHeaderValue != null) {
                httpRequest.addHeader(key, this.hostHeaderValue);
                continue;
            }
            if (response.getProxyBaseUrl() == null) continue;
            httpRequest.addHeader(key, URI.create(response.getProxyBaseUrl()).getAuthority());
        }
        if (response.getAdditionalProxyRequestHeaders() != null) {
            for (String key : response.getAdditionalProxyRequestHeaders().keys()) {
                httpRequest.setHeader(key, response.getAdditionalProxyRequestHeaders().getHeader(key).firstValue());
            }
        }
    }

    private static boolean requestHeaderShouldBeTransferred(String key) {
        return !FORBIDDEN_HEADERS.contains(key.toLowerCase());
    }

    private static boolean responseHeaderShouldBeTransferred(String key) {
        String lowerCaseKey = key.toLowerCase();
        return !FORBIDDEN_HEADERS.contains(lowerCaseKey) && !lowerCaseKey.startsWith("access-control");
    }

    private static void addBodyIfPostPutOrPatch(HttpRequest httpRequest, ResponseDefinition response) throws UnsupportedEncodingException {
        Request originalRequest = response.getOriginalRequest();
        if (originalRequest.getMethod().isOneOf(RequestMethod.PUT, RequestMethod.POST, RequestMethod.PATCH)) {
            HttpEntityEnclosingRequest requestWithEntity = (HttpEntityEnclosingRequest)httpRequest;
            requestWithEntity.setEntity(ProxyResponseRenderer.buildEntityFrom(originalRequest));
        }
    }

    private static HttpEntity buildEntityFrom(Request originalRequest) {
        ContentTypeHeader contentTypeHeader = originalRequest.contentTypeHeader().or("text/plain");
        ContentType contentType = ContentType.create(contentTypeHeader.mimeTypePart(), contentTypeHeader.encodingPart().or("utf-8"));
        if (originalRequest.containsHeader(TRANSFER_ENCODING) && originalRequest.header(TRANSFER_ENCODING).firstValue().equals("chunked")) {
            return ProxyResponseRenderer.applyGzipWrapperIfRequired(originalRequest, new InputStreamEntity(new ByteArrayInputStream(originalRequest.getBody()), -1L, contentType));
        }
        return ProxyResponseRenderer.applyGzipWrapperIfRequired(originalRequest, new ByteArrayEntity(originalRequest.getBody()));
    }

    private static HttpEntity applyGzipWrapperIfRequired(Request originalRequest, HttpEntity content) {
        if (originalRequest.containsHeader(CONTENT_ENCODING) && originalRequest.header(CONTENT_ENCODING).firstValue().contains("gzip")) {
            return new GzipCompressingEntity(content);
        }
        return content;
    }
}

