/*
 * Decompiled with CFR 0.152.
 */
package com.auto.framework.operation.commmand;

import com.auto.framework.operation.commmand.CommandRequest;
import com.auto.framework.operation.commmand.CommandResult;
import com.auto.framework.operation.commmand.CommandRunner;
import com.auto.framework.reporter.TestReporter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;

public class TestCommandExecution {
    public static final long DEFAULT_COMMAND_TIMEOUT = 60L;
    private static Map<String, String> mpEnv = Collections.synchronizedMap(new HashMap());
    private static Map<String, String> mpDefaultEnv = new HashMap<String, String>();

    private static void initDefaultEnvMap() {
        mpDefaultEnv.put("TZ", TimeZone.getDefault().getID());
    }

    public static CommandResult runCommandWithoutTrace(String ... s2) {
        CommandRequest cRequest = new CommandRequest(s2);
        CommandRunner commandRunner = new CommandRunner(TestCommandExecution.generateCompEnvironment());
        commandRunner.runCommand(cRequest);
        return commandRunner.getCommandResult();
    }

    public static CommandResult runCommand(String ... arrCmd) {
        CommandRequest cRequest = new CommandRequest(arrCmd);
        CommandRunner commandRunner = new CommandRunner(TestCommandExecution.generateCompEnvironment());
        commandRunner.runCommand(cRequest);
        TestReporter.traceExecution(cRequest, commandRunner.getCommandResult());
        return commandRunner.getCommandResult();
    }

    public static CommandResult runCommand(String[] arrCmd, String host) {
        CommandRequest cRequest = new CommandRequest(arrCmd, host);
        CommandRunner commandRunner = new CommandRunner(TestCommandExecution.generateCompEnvironment());
        commandRunner.runCommand(cRequest);
        TestReporter.traceExecution(cRequest, commandRunner.getCommandResult());
        return commandRunner.getCommandResult();
    }

    public static CommandResult runCommand(String[] arrCmd, Map<String, String> mapEnv) {
        CommandRequest cRequest = new CommandRequest(arrCmd);
        Map<String, String> env = TestCommandExecution.generateCompEnvironment();
        env.putAll(mapEnv);
        CommandRunner commandRunner = new CommandRunner(env);
        commandRunner.runCommand(cRequest);
        TestReporter.traceExecution(cRequest, commandRunner.getCommandResult());
        return commandRunner.getCommandResult();
    }

    public static CommandResult runCommand(String[] arrCmd, Map<String, String> mapEnv, String host) {
        CommandRequest cRequest = new CommandRequest(arrCmd, host);
        Map<String, String> env = TestCommandExecution.generateCompEnvironment();
        env.putAll(mapEnv);
        CommandRunner commandRunner = new CommandRunner(env);
        commandRunner.runCommand(cRequest);
        TestReporter.traceExecution(cRequest, commandRunner.getCommandResult());
        return commandRunner.getCommandResult();
    }

    public static final void reset() {
        mpEnv.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> generateCompEnvironment() {
        HashMap<String, String> mpUserEnv = new HashMap<String, String>();
        Map<String, String> map = mpEnv;
        synchronized (map) {
            mpUserEnv.putAll(mpEnv);
        }
        if (!mpUserEnv.isEmpty()) {
            for (Map.Entry entry : mpDefaultEnv.entrySet()) {
                if (mpUserEnv.containsKey(entry.getKey())) continue;
                mpUserEnv.put((String)entry.getKey(), (String)entry.getValue());
            }
        }
        return mpUserEnv;
    }

    public static void setenv(String sEnv, String sValue) {
        if (null != sValue) {
            mpEnv.put(sEnv, sValue);
        } else {
            mpEnv.remove(sEnv);
        }
    }

    public static void unSetEnv(String sEnv) {
        if (mpEnv.containsKey(sEnv)) {
            mpEnv.remove(sEnv);
        }
    }

    public static void unSetDefaultEnv(String sEnv) {
        if (mpDefaultEnv.containsKey(sEnv)) {
            mpDefaultEnv.remove(sEnv);
        }
    }

    public static void SetDefaultEnv(String sKey, String sValue) {
        mpDefaultEnv.put(sKey, sValue);
    }

    static {
        TestCommandExecution.initDefaultEnvMap();
    }
}

