/*
 * Decompiled with CFR 0.152.
 */
package com.auto.framework.runner.job;

import com.auto.framework.reporter.ErrorReporter;
import com.auto.framework.reporter.TestReporter;
import com.auto.framework.reporter.data.TestDataReporter;
import com.auto.framework.runner.job.ITestJob;
import com.auto.framework.runner.job.SingleTestRunner;
import com.auto.framework.runner.job.TestJobResult;
import java.util.function.Consumer;

public class TestJob
implements ITestJob {
    private final String fqcn;
    private TestJobResult result;
    private final Consumer<Exception> exceptionHandler;

    public TestJob(String fqcn, Consumer<Exception> exceptionHandler) {
        this.fqcn = fqcn;
        this.exceptionHandler = exceptionHandler;
    }

    @Override
    public void execute() {
        long start = System.currentTimeMillis();
        TestJobResult.JobStatus status = TestJobResult.JobStatus.FAIL;
        try {
            SingleTestRunner.runTest(this.fqcn);
            status = TestJobResult.JobStatus.SUCCESS;
        }
        catch (Exception exception) {
            // empty catch block
        }
        long timeTaken = System.currentTimeMillis() - start;
        ErrorReporter errorReporter = TestReporter.getErrorReporter();
        this.result = new TestJobResult(!TestReporter.testFailed(), this.getTime(timeTaken), this.getTestName(), this.getClassName(), this.fqcn, errorReporter.getFirstFailure(), status, TestDataReporter.getTestData());
    }

    private String getTime(long timeTaken) {
        long minutes = timeTaken / 1000L / 60L;
        long seconds = timeTaken / 1000L % 60L;
        return minutes + "min" + seconds + "sec";
    }

    public String getTestName() {
        String[] split = this.fqcn.split("\\.");
        return split[split.length - 1];
    }

    public String getClassName() {
        String[] split = this.fqcn.split("\\.");
        return split.length >= 2 ? split[split.length - 2] : "";
    }

    public String getFqcn() {
        return this.fqcn;
    }

    @Override
    public TestJobResult getResult() {
        return this.result;
    }

    @Override
    public void handleException(Exception e) {
        if (null != this.exceptionHandler) {
            this.exceptionHandler.accept(e);
        }
    }
}

