/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.selenium.webdriven.commands;

import com.thoughtworks.selenium.webdriven.ElementFinder;
import com.thoughtworks.selenium.webdriven.JavascriptLibrary;
import com.thoughtworks.selenium.webdriven.SeleneseCommand;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;

public class GetText
extends SeleneseCommand<String> {
    private final JavascriptLibrary library;
    private final ElementFinder finder;

    public GetText(JavascriptLibrary library, ElementFinder finder) {
        this.library = library;
        this.finder = finder;
    }

    @Override
    protected String handleSeleneseCommand(WebDriver driver, String locator, String ignored) {
        String getText = this.library.getSeleniumScript("getText.js");
        try {
            return (String)((JavascriptExecutor)((Object)driver)).executeScript("return (" + getText + ")(arguments[0]);", locator);
        }
        catch (WebDriverException e) {
            WebElement element = this.finder.findElement(driver, locator);
            return element.getText();
        }
    }
}

