/*
 * Decompiled with CFR 0.152.
 */
package net.javacrumbs.jsonunit.core.internal;

import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.Moshi;
import java.io.IOException;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.RoundingMode;
import net.javacrumbs.jsonunit.core.internal.AbstractNodeFactory;
import net.javacrumbs.jsonunit.core.internal.GenericNodeBuilder;
import net.javacrumbs.jsonunit.core.internal.Node;
import net.javacrumbs.jsonunit.core.internal.NodeBuilder;
import net.javacrumbs.jsonunit.core.internal.Utils;

class MoshiNodeFactory
extends AbstractNodeFactory {
    private static final Moshi moshi = new Moshi.Builder().build();
    private static final NodeBuilder moshiNodeBuilder = new MoshiNodeBuilder();

    MoshiNodeFactory() {
    }

    @Override
    protected Node doConvertValue(Object source) {
        return this.newNode(source);
    }

    @Override
    protected Node nullNode() {
        return this.newNode(null);
    }

    @Override
    protected Node readValue(String source, String label, boolean lenient) {
        try {
            JsonAdapter adapter = moshi.adapter(Object.class);
            if (lenient) {
                adapter = adapter.lenient();
            }
            return this.newNode(adapter.fromJson(source));
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Can not parse " + label + " value.", e);
        }
    }

    @Override
    protected Node readValue(Reader value, String label, boolean lenient) {
        try {
            Node node = this.readValue(Utils.readAsString(value), label, lenient);
            return node;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Can not parse " + label + " value.", e);
        }
        finally {
            Utils.closeQuietly(value);
        }
    }

    private Node newNode(Object source) {
        return moshiNodeBuilder.newNode(source);
    }

    @Override
    public boolean isPreferredFor(Object source) {
        return false;
    }

    private static class MoshiNodeBuilder
    extends GenericNodeBuilder {
        private MoshiNodeBuilder() {
        }

        @Override
        public Node newNode(Object object) {
            if (object instanceof Number) {
                return new MoshiNumberNode((Number)object);
            }
            return super.newNode(object);
        }

        private static final class MoshiNumberNode
        extends GenericNodeBuilder.NumberNode {
            private MoshiNumberNode(Number value) {
                super(value);
            }

            @Override
            public BigDecimal decimalValue() {
                BigDecimal value = super.decimalValue().stripTrailingZeros();
                return value.scale() < 0 ? value.setScale(0, RoundingMode.HALF_UP) : value;
            }

            @Override
            public String toString() {
                return this.decimalValue().toString();
            }
        }
    }
}

