/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.firefox.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.net.ConnectException;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.openqa.selenium.Beta;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.firefox.ExtensionConnection;
import org.openqa.selenium.firefox.FirefoxBinary;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.openqa.selenium.internal.Lock;
import org.openqa.selenium.logging.LocalLogs;
import org.openqa.selenium.logging.NeedsLocalLogs;
import org.openqa.selenium.net.PortProber;
import org.openqa.selenium.remote.BeanToJsonConverter;
import org.openqa.selenium.remote.Command;
import org.openqa.selenium.remote.JsonToBeanConverter;
import org.openqa.selenium.remote.Response;
import org.openqa.selenium.remote.SessionId;
import org.openqa.selenium.remote.internal.CircularOutputStream;

@Beta
public class MarionetteConnection
implements ExtensionConnection,
NeedsLocalLogs {
    private static final int BUFFER_SIZE = 4096;
    private final long connectTimeout;
    private final FirefoxBinary process;
    private final FirefoxProfile profile;
    private final String host;
    private final Lock lock;
    private File profileDir;
    private int port;
    private static Map<String, String> seleniumToMarionetteCommandMap = ImmutableMap.builder().put("get", "get").put("getAlertText", "getTextFromDialog").put("acceptAlert", "acceptDialog").put("dismissAlert", "dismissDialog").put("setAlertValue", "sendKeysToDialog").put("getCurrentWindowHandle", "getWindow").put("getWindowHandles", "getWindows").put("close", "closeWindow").put("getCurrentUrl", "getUrl").put("findChildElement", "findElement").put("findChildElements", "findElements").put("getElementLocation", "getElementPosition").put("getCookies", "getAllCookies").put("quit", "deleteSession").put("mouseMoveTo", "move").put("mouseButtonDown", "press").put("mouseButtonUp", "release").put("mouseClick", "click").build();
    private Socket socket;
    private PrintWriter writer;
    private Reader reader;
    private String marionetteId;
    private LocalLogs logs = LocalLogs.getNullLogger();

    public MarionetteConnection(Lock lock, FirefoxBinary binary, FirefoxProfile profile, String host) throws Exception {
        this.host = host;
        this.connectTimeout = binary.getTimeout();
        this.lock = lock;
        this.profile = profile;
        this.process = binary;
    }

    @Override
    public void start() throws IOException {
        this.port = PortProber.findFreePort();
        this.profile.setPreference("marionette.defaultPrefs.enabled", true);
        this.profile.setPreference("marionette.defaultPrefs.port", this.port);
        this.profile.setPreference("browser.warnOnQuit", false);
        this.lock.lock(this.connectTimeout);
        try {
            this.profileDir = this.profile.layoutOnDisk();
            String firefoxLogFile = System.getProperty("webdriver.firefox.logfile");
            if (firefoxLogFile != null) {
                if ("/dev/stdout".equals(firefoxLogFile)) {
                    this.process.setOutputWatcher(System.out);
                } else {
                    File logFile = new File(firefoxLogFile);
                    this.process.setOutputWatcher(new CircularOutputStream(logFile, 4096));
                }
            }
            this.process.startProfile(this.profile, this.profileDir, "-foreground", "-marionette");
            long waitUntil = System.currentTimeMillis() + this.connectTimeout;
            while (!this.isConnected()) {
                this.tryToConnect(this.host, this.port);
                if (waitUntil < System.currentTimeMillis()) {
                    throw new Error("Can't connect to " + this.host + ":" + this.port + "\n" + this.process.getConsoleOutput());
                }
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException ignored) {}
            }
        }
        catch (IOException e) {
            throw new WebDriverException(String.format("Failed to connect to binary %s on port %d; process output follows: %n%s", this.process.toString(), this.port, this.process.getConsoleOutput()), e);
        }
        catch (WebDriverException e) {
            throw new WebDriverException(String.format("Failed to connect to binary %s on port %d; process output follows: %n%s", this.process.toString(), this.port, this.process.getConsoleOutput()), e);
        }
        catch (Exception e) {
            throw new WebDriverException(e);
        }
        finally {
            this.lock.unlock();
        }
        String ignored = this.receiveResponse();
        this.sendCommand(this.serializeCommand(new Command(null, "getMarionetteID")));
        String getMarionetteIdRawResponse = this.receiveResponse();
        System.out.println(getMarionetteIdRawResponse);
        Map map = new JsonToBeanConverter().convert(Map.class, getMarionetteIdRawResponse);
        this.marionetteId = map.get("id").toString();
    }

    private void tryToConnect(String host, int port) {
        try {
            this.socket = new Socket(host, port);
            this.writer = new PrintWriter(this.socket.getOutputStream(), true);
            this.reader = new InputStreamReader(this.socket.getInputStream());
        }
        catch (ConnectException ex) {
            this.socket = null;
            this.writer = null;
            this.reader = null;
        }
        catch (IOException ex) {
            this.socket = null;
            this.writer = null;
            this.reader = null;
        }
    }

    @Override
    public Response execute(Command command) throws IOException {
        Response response;
        String commandAsString = this.serializeCommand(command);
        this.sendCommand(commandAsString);
        String rawResponse = this.receiveResponse();
        Map map = new JsonToBeanConverter().convert(Map.class, rawResponse);
        if ("newSession".equals(command.getName())) {
            response = new Response(new SessionId(map.get("sessionId").toString()));
            response.setValue(map.get("value"));
        } else {
            response = new JsonToBeanConverter().convert(Response.class, rawResponse);
            if (map.containsKey("error")) {
                response.setValue(map.get("error"));
            } else if ("getActiveElement".equals(command.getName()) && response.getStatus() == 0) {
                HashMap<String, String> wrappedElement = Maps.newHashMap();
                wrappedElement.put("ELEMENT", response.getValue().toString());
                response.setValue(wrappedElement);
            }
        }
        return response;
    }

    private String serializeCommand(Command command) {
        String commandName = command.getName();
        HashMap<String, Object> params = Maps.newHashMap();
        params.putAll(command.getParameters());
        if ("newSession".equals(commandName)) {
            params.remove("desiredCapabilities");
        } else if ("setTimeout".equals(commandName)) {
            String timeoutType = (String)params.get("type");
            if ("implicit".equals(timeoutType)) {
                commandName = "setSearchTimeout";
            } else if ("script".equals(timeoutType)) {
                commandName = "setScriptTimeout";
            }
            params.remove("type");
        } else if ("findChildElement".equals(commandName) || "findChildElements".equals(commandName)) {
            this.renameParameter(params, "id", "element");
        } else if ("mouseClick".equals(commandName) || "mouseDoubleClick".equals(commandName) || "mouseButtonDown".equals(commandName) || "mouseButtonUp".equals(commandName) || "mouseMoveTo".equals(commandName)) {
            String actionName = seleniumToMarionetteCommandMap.containsKey(commandName) ? seleniumToMarionetteCommandMap.get(commandName) : commandName;
            commandName = "actionChain";
            ArrayList<String> action = Lists.newArrayList();
            action.add(actionName);
            if (params.containsKey("element")) {
                action.add((String)params.get("element"));
                params.remove("element");
            }
            ArrayList<ArrayList<String>> actions2 = Lists.newArrayList();
            actions2.add(action);
            params.put("chain", actions2);
        } else if ("setAlertValue".equals(commandName)) {
            this.renameParameter(params, "text", "value");
        } else if ("switchToFrame".equals(commandName) && params.get("id") instanceof Map) {
            params.put("element", ((Map)params.get("id")).get("ELEMENT"));
            params.remove("id");
        }
        if (seleniumToMarionetteCommandMap.containsKey(commandName)) {
            commandName = seleniumToMarionetteCommandMap.get(commandName);
        }
        HashMap<String, Object> map = Maps.newHashMap();
        map.put("to", this.marionetteId != null ? this.marionetteId : "root");
        map.put("name", commandName);
        if (command.getSessionId() != null) {
            map.put("sessionId", command.getSessionId().toString());
        }
        map.put("parameters", params);
        return new BeanToJsonConverter().convert(map);
    }

    private void renameParameter(Map<String, Object> params, String origParName, String newParName) {
        Object o = params.get(origParName);
        params.put(newParName, o);
        params.remove(origParName);
    }

    private void sendCommand(String commandAsString) {
        String line = "" + commandAsString.length() + ":" + commandAsString;
        System.out.println(line);
        this.writer.write(line);
        this.writer.flush();
    }

    private String receiveResponse() throws IOException {
        StringBuilder response = new StringBuilder();
        char[] buf = new char[1024];
        int len = this.reader.read(buf);
        response.append(buf, 0, len);
        String[] parts = response.toString().split(":", 2);
        int contentLength = Integer.parseInt(parts[0]);
        while (response.length() < contentLength + ":".length() + parts[0].length()) {
            buf = new char[1024];
            len = this.reader.read(buf);
            if (len > 0) {
                response.append(buf, 0, len);
                continue;
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {}
        }
        System.out.println("<- |" + response.toString() + "|");
        parts = response.toString().split(":", 2);
        return parts[1].substring(0, contentLength);
    }

    @Override
    public void quit() {
        try {
            this.writer.close();
            this.reader.close();
            this.socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.socket = null;
        this.process.quit();
        if (this.profileDir != null) {
            this.profile.clean(this.profileDir);
        }
    }

    @Override
    public boolean isConnected() {
        return this.socket != null && this.socket.isConnected();
    }

    @Override
    public void setLocalLogs(LocalLogs logs) {
        this.logs = logs;
    }

    @Override
    public URI getAddressOfRemoteServer() {
        Preconditions.checkState(this.host == null, "The host must be non-null.");
        Preconditions.checkState(this.port != 0, "The port must be non-0.");
        try {
            return new URI("net.tcp://" + this.host + ":" + this.port);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }
}

