/*
 * Decompiled with CFR 0.152.
 */
package com.auto.framework.operation.commmand;

import com.auto.framework.operation.Operation;
import com.auto.framework.operation.commmand.CommandRequest;
import com.auto.framework.operation.commmand.CommandResult;
import com.auto.framework.operation.commmand.CommandRunner;
import com.auto.framework.operation.commmand.TestCommandExecution;
import com.auto.framework.reporter.TestReporter;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;

public abstract class AbstractCommandOperation
implements Operation {
    private final CommandRequest request;
    private final String installationDir;
    private final Map<String, String> mpEnv = Maps.newHashMap();
    private long commandTimeout = 60000L;
    protected CommandResult result = null;
    private String cwd;

    public AbstractCommandOperation(String installationDir, CommandRequest commandRequest) {
        this.installationDir = installationDir;
        this.request = commandRequest;
        this.mpEnv.put("TZ", TimeZone.getDefault().getID());
    }

    public AbstractCommandOperation(String installationDir, CommandRequest commandRequest, Map<String, String> mapEnvVariable) {
        this.installationDir = installationDir;
        this.request = commandRequest;
        this.mpEnv.put("TZ", TimeZone.getDefault().getID());
        this.mpEnv.putAll(mapEnvVariable);
    }

    @Override
    public void execute() {
        if (this.shouldRunInBackground()) {
            new Thread(this::prepareAndExecute).start();
        } else {
            this.prepareAndExecute();
        }
    }

    @Override
    public CommandRequest getRequest() {
        return this.request;
    }

    @Override
    public CommandResult getResult() {
        return this.result;
    }

    private void prepareAndExecute() {
        try {
            CommandRunner commandRunner = new CommandRunner(this.getEnv(), this.getInstallationDir(), this.getCommandTimeout());
            commandRunner.runCommand(this.request);
            this.result = commandRunner.getCommandResult();
        }
        finally {
            TestReporter.traceExecution(this.request, this.result);
        }
    }

    protected Map<String, String> getEnv() {
        HashMap<String, String> map = Maps.newHashMap(TestCommandExecution.generateCompEnvironment());
        map.putAll(this.mpEnv);
        return map;
    }

    public void setEnv(String name, String val) {
        this.mpEnv.put(name, val);
    }

    public String getInstallationDir() {
        return this.installationDir;
    }

    protected String getHost() {
        return this.request.getHost();
    }

    public void setCommandTimeout(long commandTimeout) {
        this.commandTimeout = commandTimeout;
    }

    public long getCommandTimeout() {
        return this.commandTimeout;
    }
}

