/*
 * Decompiled with CFR 0.152.
 */
package com.auto.framework.reporter;

import com.auto.framework.iface.ITestCase;
import com.auto.framework.iface.ITestComponent;
import com.auto.framework.reporter.TestReporter;
import java.io.File;
import org.apache.commons.lang3.StringUtils;

public class ErrorReporter {
    private ITestCase testCase = null;
    private int iErrorNum = 0;
    private String sOutputDir = null;
    private int iPass = 0;
    private int iFail = 0;
    private int iFatal = 0;
    private Throwable fatalThrowable;
    private boolean errorLogging = false;
    private String sFirstFailure = null;
    private static boolean saveConfigurationOnError = true;
    private static boolean bSaveInformation = true;
    private static boolean captureSnapshotOnError = true;

    public ErrorReporter(ITestCase tTest, String sOutputDir) {
        this.testCase = tTest;
        this.sOutputDir = sOutputDir;
    }

    private String getCurrentErrorDir() {
        return this.getOutputDir() + File.separator + "error" + this.iErrorNum;
    }

    private String getOutputDir() {
        return this.sOutputDir;
    }

    public void pass() {
        ++this.iPass;
    }

    public void fail(String sMessage) {
        if (this.errorLogging) {
            return;
        }
        this.saveFailure(sMessage);
        ++this.iFail;
        this.reportError();
    }

    public void fatal(Throwable t) {
        if (this.errorLogging) {
            return;
        }
        this.saveFailure(t.getMessage());
        ++this.iFatal;
        this.fatalThrowable = t;
        this.reportError();
    }

    private ITestCase getTestCase() {
        return this.testCase;
    }

    private void reportError() {
        if (!bSaveInformation) {
            return;
        }
        try {
            this.errorLogging = true;
            ++this.iErrorNum;
            String sErrorDir = this.getCurrentErrorDir();
            new File(sErrorDir).mkdir();
            this.getTestCase().getTestComponents().forEach(cComponent -> {
                if (null != cComponent) {
                    TestReporter.TRACE("saving information on error for " + cComponent);
                    String sTargetDir = this.getCurrentErrorDir() + File.separator + cComponent.getComponentName() + "_" + cComponent.getHost();
                    new File(sTargetDir).mkdirs();
                    if (saveConfigurationOnError) {
                        this.saveFileOnError(this.getTestCase().getSandBoxDir(), sTargetDir);
                    }
                    if (captureSnapshotOnError) {
                        String sSnapshotDir = sTargetDir + "/snapshotOnError/";
                        new File(sSnapshotDir).mkdir();
                        this.captureSnapshotOnError((ITestComponent)cComponent, sSnapshotDir);
                    }
                }
            });
        }
        finally {
            this.errorLogging = false;
        }
    }

    private void saveFileOnError(String sSourcePath, String sDestination) {
    }

    private void captureSnapshotOnError(ITestComponent cComponent, String sTargetDir) {
    }

    public int getPass() {
        if (this.iFail + this.iFatal + this.iPass <= 0) {
            return 1;
        }
        return this.iPass;
    }

    public int getFail() {
        return this.iFail;
    }

    public int getFatal() {
        return this.iFatal;
    }

    public void dump() {
        this.saveFileOnError(this.getOutputDir(), this.getOutputDir());
    }

    public String getFirstFailure() {
        return this.sFirstFailure;
    }

    private void saveFailure(String sFailure) {
        if (StringUtils.isEmpty(this.sFirstFailure)) {
            this.sFirstFailure = sFailure;
        }
    }

    public Throwable getFatalThrowable() {
        return this.fatalThrowable;
    }

    public static void setSaveInformation(boolean saveInformation) {
        bSaveInformation = saveInformation;
    }

    public static void setSaveConfigurationOnError(boolean m_bSaveConfigurationOnError) {
        saveConfigurationOnError = m_bSaveConfigurationOnError;
    }

    public static void setCaptureSnapshotOnError(boolean m_bCaptureSnapshotOnError) {
        captureSnapshotOnError = m_bCaptureSnapshotOnError;
    }
}

