/*
 * Decompiled with CFR 0.152.
 */
package com.auto.framework.rules.tags;

import com.auto.framework.rules.AbstractMethodRule;
import com.auto.framework.rules.tags.Tags;
import java.util.Objects;
import org.junit.runners.model.FrameworkMethod;

public class TagsRule
extends AbstractMethodRule {
    private String[] tags;

    @Override
    protected void extractTestProperties(FrameworkMethod mTest, Object oTest) {
        Tags classAnnotation = oTest.getClass().getAnnotation(Tags.class);
        Tags methodAnnotation = mTest.getAnnotation(Tags.class);
        if (methodAnnotation != null) {
            this.tags = methodAnnotation.value();
        } else if (classAnnotation != null) {
            this.tags = classAnnotation.value();
        }
    }

    public String getTags() {
        StringBuilder sb = new StringBuilder();
        if (Objects.nonNull(this.tags)) {
            for (String str : this.tags) {
                sb.append(str).append(",");
            }
            return sb.substring(0, sb.length() - 1);
        }
        return "";
    }
}

