/*
 * Decompiled with CFR 0.152.
 */
package com.auto.framework.runner.report;

import com.auto.framework.reporter.data.TestDataReporterItem;
import com.auto.framework.runner.data.ExecutionResult;
import com.auto.framework.runner.job.TestJobResult;
import com.auto.framework.runner.report.AbstractReporter;
import dnl.utils.text.table.TextTable;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class ConsoleReporter
extends AbstractReporter {
    @Override
    public void accept(ExecutionResult result) {
        try {
            System.out.println();
            System.out.println();
            System.out.println("\u001b[33m\u001b[1mDetail report\u001b[0m");
            this.printTestDetail(result);
            System.out.println();
            System.out.println();
            System.out.println("\u001b[33m\u001b[1mTest Summary\u001b[0m");
            this.printSummary(result);
            System.out.println();
            System.out.println();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void printSummary(ExecutionResult result) {
        Object[][] summaryData = new Object[1][3];
        summaryData[0][0] = result.getSummary().getPass();
        summaryData[0][1] = result.getSummary().getFatal();
        summaryData[0][2] = result.getSummary().getFail();
        TextTable summary = new TextTable(SUMMARY_COLUMN_NAMES, summaryData);
        summary.printTable();
    }

    private void printTestDetail(ExecutionResult result) {
        List<TestJobResult> jobResults = result.getJobResults();
        String[] dynamicColumns = (String[])jobResults.stream().flatMap(jobResult -> jobResult.getCustomTestData().stream()).filter(TestDataReporterItem::shouldBeReported).map(item -> StringUtils.capitalize(item.getKey())).distinct().toArray(String[]::new);
        String[] headerColumns = (String[])Stream.of(DETAIL_COLUMN_NAMES, dynamicColumns).flatMap(Arrays::stream).toArray(String[]::new);
        Object[][] data = new Object[jobResults.size()][headerColumns.length];
        for (int i = 0; i < jobResults.size(); ++i) {
            for (int j = 0; j < headerColumns.length; ++j) {
                String currentHeader = headerColumns[j];
                if (currentHeader.equals("Class")) {
                    data[i][j] = jobResults.get(i).getClassName();
                    continue;
                }
                if (currentHeader.equals("Test")) {
                    data[i][j] = jobResults.get(i).getName();
                    continue;
                }
                if (currentHeader.equals("Status")) {
                    data[i][j] = this.getStatus(jobResults.get(i));
                    continue;
                }
                if (currentHeader.equals("Message")) {
                    data[i][j] = jobResults.get(i).getErrorMessage();
                    continue;
                }
                if (!CollectionUtils.isNotEmpty(jobResults.get(i).getCustomTestData())) continue;
                Optional<TestDataReporterItem> any = jobResults.get(i).getCustomTestData().stream().filter(a -> currentHeader.equalsIgnoreCase(a.getKey())).findAny();
                data[i][j] = any.isPresent() ? any.get().getValue() : "";
            }
        }
        TextTable tt = new TextTable(headerColumns, data);
        tt.printTable();
    }

    private String getStatus(TestJobResult result) {
        return result.isPass() ? "\u2714" : "\u2718";
    }
}

