/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.configuration.BrowserName;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClasses;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.WebBrowser;
import java.io.IOException;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;

@JsxClasses(value={@JsxClass(browsers={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.IE, minVersion=11.0f)}), @JsxClass(isJSObject=false, browsers={@WebBrowser(value=BrowserName.IE, maxVersion=8.0f)})})
public class History
extends SimpleScriptable {
    @JsxConstructor(value={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF, minVersion=31.0f)})
    public History() {
    }

    @Override
    public Object[] getIds() {
        int len;
        Object[] ids = super.getIds();
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_HISTORY_ENUMS_ENTRIES) && (len = this.getWindow().getWebWindow().getHistory().getLength()) > 0) {
            Object[] allIds = new Object[ids.length + len];
            System.arraycopy(ids, 0, allIds, 0, ids.length);
            for (int i = 0; i < len; ++i) {
                allIds[ids.length + i] = i;
            }
            ids = allIds;
        }
        return ids;
    }

    @Override
    public boolean has(int index, Scriptable start) {
        if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_HISTORY_ENUMS_ENTRIES)) {
            History h2 = (History)start;
            if (index >= 0 && index < h2.getLength()) {
                return true;
            }
        }
        return super.has(index, start);
    }

    @Override
    public Object get(int index, Scriptable start) {
        History h2 = (History)start;
        if (index < 0 || index >= h2.getLength()) {
            return NOT_FOUND;
        }
        return this.item(index);
    }

    @JsxGetter
    public int getLength() {
        WebWindow w = this.getWindow().getWebWindow();
        return w.getHistory().getLength();
    }

    @JsxFunction
    public void back() {
        WebWindow w = this.getWindow().getWebWindow();
        try {
            w.getHistory().back();
        }
        catch (IOException e) {
            Context.throwAsScriptRuntimeEx(e);
        }
    }

    @JsxFunction
    public void forward() {
        WebWindow w = this.getWindow().getWebWindow();
        try {
            w.getHistory().forward();
        }
        catch (IOException e) {
            Context.throwAsScriptRuntimeEx(e);
        }
    }

    @JsxFunction
    public void go(int relativeIndex) {
        WebWindow w = this.getWindow().getWebWindow();
        try {
            w.getHistory().go(relativeIndex);
        }
        catch (IOException e) {
            Context.throwAsScriptRuntimeEx(e);
        }
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF)})
    public String getCurrent() {
        throw Context.reportRuntimeError("Permission denied to get property History.current");
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF)})
    public String getPrevious() {
        throw Context.reportRuntimeError("Permission denied to get property History.previous");
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.FF)})
    public String getNext() {
        throw Context.reportRuntimeError("Permission denied to get property History.next");
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.FF)})
    public String item(int index) {
        throw Context.reportRuntimeError("Permission denied to call method History.item");
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.IE, minVersion=11.0f)})
    public void replaceState(Object object, String title, String url) {
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.IE, minVersion=11.0f)})
    public void pushState(Object object, String title, String url) {
    }
}

