/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.internet;

import com.sun.mail.util.ASCIIUtility;
import com.sun.mail.util.LineOutputStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Vector;
import javax.activation.DataHandler;
import javax.activation.FileDataSource;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.internet.CachedDataHandler;
import javax.mail.internet.ContentDisposition;
import javax.mail.internet.ContentType;
import javax.mail.internet.HeaderTokenizer;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimePart;
import javax.mail.internet.MimePartDataSource;
import javax.mail.internet.MimeUtility;
import javax.mail.internet.ParseException;
import javax.mail.internet.SharedInputStream;

public class MimeBodyPart
extends BodyPart
implements MimePart {
    private static boolean setDefaultTextCharset = true;
    private static boolean setContentTypeFileName = true;
    private static boolean encodeFileName = false;
    private static boolean decodeFileName = false;
    static boolean cacheMultipart = true;
    protected DataHandler dh;
    protected byte[] content;
    protected InputStream contentStream;
    protected InternetHeaders headers;

    public MimeBodyPart() {
        this.headers = new InternetHeaders();
    }

    public MimeBodyPart(InputStream is) throws MessagingException {
        if (!(is instanceof ByteArrayInputStream || is instanceof BufferedInputStream || is instanceof SharedInputStream)) {
            is = new BufferedInputStream(is);
        }
        this.headers = new InternetHeaders(is);
        if (is instanceof SharedInputStream) {
            SharedInputStream sis = (SharedInputStream)((Object)is);
            this.contentStream = sis.newStream(sis.getPosition(), -1L);
        } else {
            try {
                this.content = ASCIIUtility.getBytes(is);
            }
            catch (IOException ioex) {
                throw new MessagingException("Error reading input stream", ioex);
            }
        }
    }

    public MimeBodyPart(InternetHeaders headers, byte[] content) throws MessagingException {
        this.headers = headers;
        this.content = content;
    }

    public int getSize() throws MessagingException {
        if (this.content != null) {
            return this.content.length;
        }
        if (this.contentStream != null) {
            try {
                int size = this.contentStream.available();
                if (size > 0) {
                    return size;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return -1;
    }

    public int getLineCount() throws MessagingException {
        return -1;
    }

    public String getContentType() throws MessagingException {
        String s2 = this.getHeader("Content-Type", null);
        if (s2 == null) {
            s2 = "text/plain";
        }
        return s2;
    }

    public boolean isMimeType(String mimeType) throws MessagingException {
        return MimeBodyPart.isMimeType(this, mimeType);
    }

    public String getDisposition() throws MessagingException {
        return MimeBodyPart.getDisposition(this);
    }

    public void setDisposition(String disposition) throws MessagingException {
        MimeBodyPart.setDisposition(this, disposition);
    }

    public String getEncoding() throws MessagingException {
        return MimeBodyPart.getEncoding(this);
    }

    public String getContentID() throws MessagingException {
        return this.getHeader("Content-Id", null);
    }

    public void setContentID(String cid) throws MessagingException {
        if (cid == null) {
            this.removeHeader("Content-ID");
        } else {
            this.setHeader("Content-ID", cid);
        }
    }

    public String getContentMD5() throws MessagingException {
        return this.getHeader("Content-MD5", null);
    }

    public void setContentMD5(String md5) throws MessagingException {
        this.setHeader("Content-MD5", md5);
    }

    public String[] getContentLanguage() throws MessagingException {
        return MimeBodyPart.getContentLanguage(this);
    }

    public void setContentLanguage(String[] languages) throws MessagingException {
        MimeBodyPart.setContentLanguage(this, languages);
    }

    public String getDescription() throws MessagingException {
        return MimeBodyPart.getDescription(this);
    }

    public void setDescription(String description) throws MessagingException {
        this.setDescription(description, null);
    }

    public void setDescription(String description, String charset) throws MessagingException {
        MimeBodyPart.setDescription(this, description, charset);
    }

    public String getFileName() throws MessagingException {
        return MimeBodyPart.getFileName(this);
    }

    public void setFileName(String filename) throws MessagingException {
        MimeBodyPart.setFileName(this, filename);
    }

    public InputStream getInputStream() throws IOException, MessagingException {
        return this.getDataHandler().getInputStream();
    }

    protected InputStream getContentStream() throws MessagingException {
        if (this.contentStream != null) {
            return ((SharedInputStream)((Object)this.contentStream)).newStream(0L, -1L);
        }
        if (this.content != null) {
            return new ByteArrayInputStream(this.content);
        }
        throw new MessagingException("No content");
    }

    public InputStream getRawInputStream() throws MessagingException {
        return this.getContentStream();
    }

    public DataHandler getDataHandler() throws MessagingException {
        if (this.dh == null) {
            this.dh = new DataHandler(new MimePartDataSource(this));
        }
        return this.dh;
    }

    public Object getContent() throws IOException, MessagingException {
        Object c = this.getDataHandler().getContent();
        if (cacheMultipart && (c instanceof Multipart || c instanceof Message) && !(this.dh instanceof CachedDataHandler) && (this.content != null || this.contentStream != null)) {
            this.dh = MimeBodyPart.createCachedDataHandler(c, this.getContentType());
        }
        return c;
    }

    public void setDataHandler(DataHandler dh) throws MessagingException {
        this.dh = dh;
        MimeBodyPart.invalidateContentHeaders(this);
    }

    public void setContent(Object o, String type) throws MessagingException {
        if (o instanceof Multipart) {
            this.setContent((Multipart)o);
        } else {
            this.setDataHandler(new DataHandler(o, type));
        }
    }

    public void setText(String text) throws MessagingException {
        this.setText(text, null);
    }

    public void setText(String text, String charset) throws MessagingException {
        MimeBodyPart.setText(this, text, charset, "plain");
    }

    public void setText(String text, String charset, String subtype) throws MessagingException {
        MimeBodyPart.setText(this, text, charset, subtype);
    }

    public void setContent(Multipart mp) throws MessagingException {
        this.setDataHandler(new DataHandler(mp, mp.getContentType()));
        mp.setParent(this);
    }

    public void attachFile(File file) throws IOException, MessagingException {
        FileDataSource fds = new FileDataSource(file);
        this.setDataHandler(new DataHandler(fds));
        this.setFileName(fds.getName());
    }

    public void attachFile(String file) throws IOException, MessagingException {
        File f = new File(file);
        this.attachFile(f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveFile(File file) throws IOException, MessagingException {
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));
        InputStream in = this.getInputStream();
        try {
            int len;
            byte[] buf = new byte[8192];
            while ((len = in.read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException ex) {}
            try {
                if (out != null) {
                    ((OutputStream)out).close();
                }
            }
            catch (IOException ex) {}
        }
    }

    public void saveFile(String file) throws IOException, MessagingException {
        File f = new File(file);
        this.saveFile(f);
    }

    public void writeTo(OutputStream os) throws IOException, MessagingException {
        MimeBodyPart.writeTo(this, os, null);
    }

    public String[] getHeader(String name) throws MessagingException {
        return this.headers.getHeader(name);
    }

    public String getHeader(String name, String delimiter) throws MessagingException {
        return this.headers.getHeader(name, delimiter);
    }

    public void setHeader(String name, String value) throws MessagingException {
        this.headers.setHeader(name, value);
    }

    public void addHeader(String name, String value) throws MessagingException {
        this.headers.addHeader(name, value);
    }

    public void removeHeader(String name) throws MessagingException {
        this.headers.removeHeader(name);
    }

    public Enumeration getAllHeaders() throws MessagingException {
        return this.headers.getAllHeaders();
    }

    public Enumeration getMatchingHeaders(String[] names) throws MessagingException {
        return this.headers.getMatchingHeaders(names);
    }

    public Enumeration getNonMatchingHeaders(String[] names) throws MessagingException {
        return this.headers.getNonMatchingHeaders(names);
    }

    public void addHeaderLine(String line) throws MessagingException {
        this.headers.addHeaderLine(line);
    }

    public Enumeration getAllHeaderLines() throws MessagingException {
        return this.headers.getAllHeaderLines();
    }

    public Enumeration getMatchingHeaderLines(String[] names) throws MessagingException {
        return this.headers.getMatchingHeaderLines(names);
    }

    public Enumeration getNonMatchingHeaderLines(String[] names) throws MessagingException {
        return this.headers.getNonMatchingHeaderLines(names);
    }

    protected void updateHeaders() throws MessagingException {
        MimeBodyPart.updateHeaders(this);
    }

    static boolean isMimeType(MimePart part, String mimeType) throws MessagingException {
        try {
            ContentType ct = new ContentType(part.getContentType());
            return ct.match(mimeType);
        }
        catch (ParseException ex) {
            return part.getContentType().equalsIgnoreCase(mimeType);
        }
    }

    static void setText(MimePart part, String text, String charset, String subtype) throws MessagingException {
        if (charset == null) {
            charset = MimeUtility.checkAscii(text) != 1 ? MimeUtility.getDefaultMIMECharset() : "us-ascii";
        }
        part.setContent(text, "text/" + subtype + "; charset=" + MimeUtility.quote(charset, "()<>@,;:\\\"\t []/?="));
    }

    static String getDisposition(MimePart part) throws MessagingException {
        String s2 = part.getHeader("Content-Disposition", null);
        if (s2 == null) {
            return null;
        }
        ContentDisposition cd2 = new ContentDisposition(s2);
        return cd2.getDisposition();
    }

    static void setDisposition(MimePart part, String disposition) throws MessagingException {
        if (disposition == null) {
            part.removeHeader("Content-Disposition");
        } else {
            String s2 = part.getHeader("Content-Disposition", null);
            if (s2 != null) {
                ContentDisposition cd2 = new ContentDisposition(s2);
                cd2.setDisposition(disposition);
                disposition = cd2.toString();
            }
            part.setHeader("Content-Disposition", disposition);
        }
    }

    static String getDescription(MimePart part) throws MessagingException {
        String rawvalue = part.getHeader("Content-Description", null);
        if (rawvalue == null) {
            return null;
        }
        try {
            return MimeUtility.decodeText(MimeUtility.unfold(rawvalue));
        }
        catch (UnsupportedEncodingException ex) {
            return rawvalue;
        }
    }

    static void setDescription(MimePart part, String description, String charset) throws MessagingException {
        if (description == null) {
            part.removeHeader("Content-Description");
            return;
        }
        try {
            part.setHeader("Content-Description", MimeUtility.fold(21, MimeUtility.encodeText(description, charset, null)));
        }
        catch (UnsupportedEncodingException uex) {
            throw new MessagingException("Encoding error", uex);
        }
    }

    static String getFileName(MimePart part) throws MessagingException {
        String filename = null;
        String s2 = part.getHeader("Content-Disposition", null);
        if (s2 != null) {
            ContentDisposition cd2 = new ContentDisposition(s2);
            filename = cd2.getParameter("filename");
        }
        if (filename == null && (s2 = part.getHeader("Content-Type", null)) != null) {
            try {
                ContentType ct = new ContentType(s2);
                filename = ct.getParameter("name");
            }
            catch (ParseException pex) {
                // empty catch block
            }
        }
        if (decodeFileName && filename != null) {
            try {
                filename = MimeUtility.decodeText(filename);
            }
            catch (UnsupportedEncodingException ex) {
                throw new MessagingException("Can't decode filename", ex);
            }
        }
        return filename;
    }

    static void setFileName(MimePart part, String name) throws MessagingException {
        String s2;
        if (encodeFileName && name != null) {
            try {
                name = MimeUtility.encodeText(name);
            }
            catch (UnsupportedEncodingException ex) {
                throw new MessagingException("Can't encode filename", ex);
            }
        }
        ContentDisposition cd2 = new ContentDisposition((s2 = part.getHeader("Content-Disposition", null)) == null ? "attachment" : s2);
        cd2.setParameter("filename", name);
        part.setHeader("Content-Disposition", cd2.toString());
        if (setContentTypeFileName && (s2 = part.getHeader("Content-Type", null)) != null) {
            try {
                ContentType cType = new ContentType(s2);
                cType.setParameter("name", name);
                part.setHeader("Content-Type", cType.toString());
            }
            catch (ParseException pex) {
                // empty catch block
            }
        }
    }

    static String[] getContentLanguage(MimePart part) throws MessagingException {
        HeaderTokenizer.Token tk;
        int tkType;
        String s2 = part.getHeader("Content-Language", null);
        if (s2 == null) {
            return null;
        }
        HeaderTokenizer h2 = new HeaderTokenizer(s2, "()<>@,;:\\\"\t []/?=");
        Vector<String> v = new Vector<String>();
        while ((tkType = (tk = h2.next()).getType()) != -4) {
            if (tkType != -1) continue;
            v.addElement(tk.getValue());
        }
        if (v.size() == 0) {
            return null;
        }
        Object[] language = new String[v.size()];
        v.copyInto(language);
        return language;
    }

    static void setContentLanguage(MimePart part, String[] languages) throws MessagingException {
        StringBuffer sb = new StringBuffer(languages[0]);
        for (int i = 1; i < languages.length; ++i) {
            sb.append(',').append(languages[i]);
        }
        part.setHeader("Content-Language", sb.toString());
    }

    static String getEncoding(MimePart part) throws MessagingException {
        HeaderTokenizer.Token tk;
        int tkType;
        String s2 = part.getHeader("Content-Transfer-Encoding", null);
        if (s2 == null) {
            return null;
        }
        if ((s2 = s2.trim()).equalsIgnoreCase("7bit") || s2.equalsIgnoreCase("8bit") || s2.equalsIgnoreCase("quoted-printable") || s2.equalsIgnoreCase("binary") || s2.equalsIgnoreCase("base64")) {
            return s2;
        }
        HeaderTokenizer h2 = new HeaderTokenizer(s2, "()<>@,;:\\\"\t []/?=");
        while ((tkType = (tk = h2.next()).getType()) != -4) {
            if (tkType != -1) continue;
            return tk.getValue();
        }
        return s2;
    }

    static void setEncoding(MimePart part, String encoding) throws MessagingException {
        part.setHeader("Content-Transfer-Encoding", encoding);
    }

    static DataHandler createCachedDataHandler(Object o, String mimeType) {
        return new CachedDataHandler(o, mimeType);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void updateHeaders(MimePart part) throws MessagingException {
        DataHandler dh = part.getDataHandler();
        if (dh == null) {
            return;
        }
        try {
            ContentDisposition cd2;
            String filename;
            String type = dh.getContentType();
            boolean composite = false;
            boolean needCTHeader = part.getHeader("Content-Type") == null;
            ContentType cType = new ContentType(type);
            if (cType.match("multipart/*")) {
                composite = true;
                Object o = dh.getContent();
                if (!(o instanceof MimeMultipart)) throw new MessagingException("MIME part of type \"" + type + "\" contains object of type " + o.getClass().getName() + " instead of MimeMultipart");
                ((MimeMultipart)o).updateHeaders();
            } else if (cType.match("message/rfc822")) {
                composite = true;
            }
            if (!composite) {
                if (part.getHeader("Content-Transfer-Encoding") == null) {
                    MimeBodyPart.setEncoding(part, MimeUtility.getEncoding(dh));
                }
                if (needCTHeader && setDefaultTextCharset && cType.match("text/*") && cType.getParameter("charset") == null) {
                    String enc = part.getEncoding();
                    String charset = enc != null && enc.equalsIgnoreCase("7bit") ? "us-ascii" : MimeUtility.getDefaultMIMECharset();
                    cType.setParameter("charset", charset);
                    type = cType.toString();
                }
            }
            if (!needCTHeader) return;
            String s2 = part.getHeader("Content-Disposition", null);
            if (s2 != null && (filename = (cd2 = new ContentDisposition(s2)).getParameter("filename")) != null) {
                cType.setParameter("name", filename);
                type = cType.toString();
            }
            part.setHeader("Content-Type", type);
            return;
        }
        catch (IOException ex) {
            throw new MessagingException("IOException updating headers", ex);
        }
    }

    static void invalidateContentHeaders(MimePart part) throws MessagingException {
        part.removeHeader("Content-Type");
        part.removeHeader("Content-Transfer-Encoding");
    }

    static void writeTo(MimePart part, OutputStream os, String[] ignoreList) throws IOException, MessagingException {
        LineOutputStream los = null;
        los = os instanceof LineOutputStream ? (LineOutputStream)os : new LineOutputStream(os);
        Enumeration hdrLines = part.getNonMatchingHeaderLines(ignoreList);
        while (hdrLines.hasMoreElements()) {
            los.writeln((String)hdrLines.nextElement());
        }
        los.writeln();
        os = MimeUtility.encode(os, part.getEncoding());
        part.getDataHandler().writeTo(os);
        os.flush();
    }

    static {
        try {
            String s2 = System.getProperty("mail.mime.setdefaulttextcharset");
            setDefaultTextCharset = s2 == null || !s2.equalsIgnoreCase("false");
            s2 = System.getProperty("mail.mime.setcontenttypefilename");
            setContentTypeFileName = s2 == null || !s2.equalsIgnoreCase("false");
            s2 = System.getProperty("mail.mime.encodefilename");
            encodeFileName = s2 != null && !s2.equalsIgnoreCase("false");
            s2 = System.getProperty("mail.mime.decodefilename");
            decodeFileName = s2 != null && !s2.equalsIgnoreCase("false");
            s2 = System.getProperty("mail.mime.cachemultipart");
            cacheMultipart = s2 == null || !s2.equalsIgnoreCase("false");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }
}

