/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.os;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilderFactory;
import org.openqa.selenium.Platform;
import org.openqa.selenium.os.CommandLine;
import org.openqa.selenium.os.ExecutableFinder;
import org.openqa.selenium.os.WindowsRegistryException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class WindowsUtils {
    public static Boolean regVersion1 = null;
    private static Logger LOG = Logger.getLogger(WindowsUtils.class.getName());
    private static final boolean THIS_IS_WINDOWS = Platform.getCurrent().is(Platform.WINDOWS);
    private static String wmic = null;
    private static File wbem = null;
    private static String taskkill = null;
    private static String reg = null;
    private static Properties env = null;

    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            System.out.println("Kills Windows processes by matching their command lines");
            System.out.println("usage: " + WindowsUtils.class.getName() + " command arg1 arg2 ...");
        }
        WindowsUtils.kill(args);
    }

    public static void traceWith(Logger log) {
        LOG = log;
    }

    public static void killByName(String name) {
        WindowsUtils.executeCommand("taskkill", "/f", "/t", "/im", name);
    }

    public static void tryToKillByName(String name) {
        if (!WindowsUtils.thisIsWindows()) {
            return;
        }
        try {
            WindowsUtils.killByName(name);
        }
        catch (WindowsRegistryException e) {
            LOG.log(Level.WARNING, "Exception thrown", e);
        }
    }

    public static void kill(String[] cmdarray) throws Exception {
        StringBuilder pattern = new StringBuilder();
        File executable = new File(cmdarray[0]);
        pattern.append("(\"?.*?\\\\)?");
        String execName = executable.getName();
        pattern.append(execName);
        if (!execName.endsWith(".exe")) {
            pattern.append("(\\.exe)?");
        }
        pattern.append("\"?");
        for (int i = 1; i < cmdarray.length; ++i) {
            pattern.append("\\s?\"?\\Q");
            pattern.append(cmdarray[i]);
            pattern.append("\\E\"?");
        }
        pattern.append("\\s*");
        Pattern cmd = Pattern.compile(pattern.toString(), 2);
        Map<String, String> procMap = WindowsUtils.procMap();
        boolean killedOne = false;
        for (String commandLine : procMap.keySet()) {
            Matcher m3;
            if (commandLine == null || !(m3 = cmd.matcher(commandLine)).matches()) continue;
            String processID = procMap.get(commandLine);
            StringBuilder logMessage = new StringBuilder("Killing PID ");
            logMessage.append(processID);
            logMessage.append(": ");
            logMessage.append(commandLine);
            LOG.info(logMessage.toString());
            try {
                WindowsUtils.killPID(processID);
                LOG.info("Killed");
                killedOne = true;
            }
            catch (WindowsRegistryException e) {}
        }
        if (!killedOne) {
            StringBuilder errorMessage = new StringBuilder("Didn't find any matches for");
            for (String arg : cmdarray) {
                errorMessage.append(" '");
                errorMessage.append(arg);
                errorMessage.append('\'');
            }
            LOG.warning(errorMessage.toString());
        }
    }

    public static void killPID(String processID) {
        CommandLine cmd = new CommandLine("taskkill", "/f", "/t", "/pid", processID);
        cmd.execute();
        String output = cmd.getStdOut();
        if (cmd.getExitCode() == 0 || cmd.getExitCode() == 128 || cmd.getExitCode() == 255) {
            return;
        }
        throw new RuntimeException("exec return code " + cmd.getExitCode() + ": " + output);
    }

    public static Map<String, String> procMap() throws Exception {
        LOG.info("Reading Windows Process List...");
        String output = WindowsUtils.executeCommand(WindowsUtils.findWMIC(), "process", "list", "full", "/format:rawxml.xsl");
        LOG.info("Done, searching for processes to kill...");
        File tempWmicBatchFile = new File("TempWmicBatchFile.bat");
        if (tempWmicBatchFile.exists()) {
            tempWmicBatchFile.delete();
        }
        Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(output.getBytes()));
        NodeList procList = doc.getElementsByTagName("INSTANCE");
        HashMap<String, String> processes = new HashMap<String, String>();
        for (int i = 0; i < procList.getLength(); ++i) {
            Element process = (Element)procList.item(i);
            NodeList propList = process.getElementsByTagName("PROPERTY");
            HashMap<String, String> procProps = new HashMap<String, String>();
            for (int j = 0; j < propList.getLength(); ++j) {
                Element property = (Element)propList.item(j);
                String propName = property.getAttribute("NAME");
                NodeList valList = property.getElementsByTagName("VALUE");
                String value = null;
                if (valList.getLength() != 0) {
                    Element valueElement = (Element)valList.item(0);
                    Text valueNode = (Text)valueElement.getFirstChild();
                    value = valueNode.getData();
                }
                procProps.put(propName, value);
            }
            String processID = (String)procProps.get("ProcessId");
            String commandLine = (String)procProps.get("CommandLine");
            processes.put(commandLine, processID);
        }
        return processes;
    }

    public static synchronized Properties loadEnvironment() {
        if (env != null) {
            return env;
        }
        env = new Properties();
        for (Map.Entry<String, String> entry : System.getenv().entrySet()) {
            env.put(entry.getKey(), entry.getValue());
        }
        return env;
    }

    public static String getProgramFilesPath() {
        return WindowsUtils.getEnvVarPath("ProgramFiles", "C:\\Program Files");
    }

    public static String getProgramFiles86Path() {
        return WindowsUtils.getEnvVarPath("ProgramFiles(x86)", "C:\\Program Files (x86)");
    }

    private static String getEnvVarPath(String envVar, String defaultValue) {
        File programFiles;
        String pf = WindowsUtils.getEnvVarIgnoreCase(envVar);
        if (pf != null && (programFiles = new File(pf)).exists()) {
            return programFiles.getAbsolutePath();
        }
        return new File(defaultValue).getAbsolutePath();
    }

    public static ImmutableList<String> getPathsInProgramFiles(String childPath) {
        return ((ImmutableList.Builder)((ImmutableList.Builder)new ImmutableList.Builder().add(WindowsUtils.getFullPath(WindowsUtils.getProgramFilesPath(), childPath))).add(WindowsUtils.getFullPath(WindowsUtils.getProgramFiles86Path(), childPath))).build();
    }

    private static String getFullPath(String parent, String child) {
        return new File(parent, child).getAbsolutePath();
    }

    public static String getLocalAppDataPath() {
        String keyLocalAppData = "HKEY_CURRENT_USER\\Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders\\Local AppData";
        String localAppDataPath = WindowsUtils.readStringRegistryValue("HKEY_CURRENT_USER\\Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders\\Local AppData");
        String userProfile = WindowsUtils.getEnvVarIgnoreCase("USERPROFILE");
        if (userProfile != null) {
            return localAppDataPath.replace("%USERPROFILE%", userProfile);
        }
        return localAppDataPath;
    }

    public static String getEnvVarIgnoreCase(String var) {
        Properties p = WindowsUtils.loadEnvironment();
        for (String key : p.stringPropertyNames()) {
            if (!key.equalsIgnoreCase(var)) continue;
            return env.getProperty(key);
        }
        return null;
    }

    public static File findSystemRoot() {
        Properties p = WindowsUtils.loadEnvironment();
        String systemRootPath = p.getProperty("SystemRoot");
        if (systemRootPath == null) {
            systemRootPath = p.getProperty("SYSTEMROOT");
        }
        if (systemRootPath == null) {
            systemRootPath = p.getProperty("systemroot");
        }
        if (systemRootPath == null) {
            throw new RuntimeException("SystemRoot apparently not set!");
        }
        File systemRoot = new File(systemRootPath);
        if (!systemRoot.exists()) {
            throw new RuntimeException("SystemRoot doesn't exist: " + systemRootPath);
        }
        return systemRoot;
    }

    public static String findWMIC() {
        File wmicExe;
        if (wmic != null) {
            return wmic;
        }
        WindowsUtils.findWBEM();
        if (null != wbem && (wmicExe = new File(WindowsUtils.findWBEM(), "wmic.exe")).exists()) {
            wmic = wmicExe.getAbsolutePath();
            return wmic;
        }
        LOG.warning("Couldn't find wmic! Hope it's on the path...");
        wmic = "wmic";
        return wmic;
    }

    public static File findWBEM() {
        if (wbem != null) {
            return wbem;
        }
        File systemRoot = WindowsUtils.findSystemRoot();
        wbem = new File(systemRoot, "system32/wbem");
        if (!wbem.exists()) {
            LOG.severe("Couldn't find wbem!");
            return null;
        }
        return wbem;
    }

    public static String findTaskKill() {
        if (taskkill != null) {
            return taskkill;
        }
        File systemRoot = WindowsUtils.findSystemRoot();
        File taskkillExe = new File(systemRoot, "system32/taskkill.exe");
        if (taskkillExe.exists()) {
            taskkill = taskkillExe.getAbsolutePath();
            return taskkill;
        }
        LOG.warning("Couldn't find taskkill! Hope it's on the path...");
        taskkill = "taskkill";
        return taskkill;
    }

    public static String findReg() {
        if (reg != null) {
            return reg;
        }
        File systemRoot = WindowsUtils.findSystemRoot();
        File regExe = new File(systemRoot, "system32/reg.exe");
        if (regExe.exists()) {
            reg = regExe.getAbsolutePath();
            return reg;
        }
        regExe = new File("c:\\ntreskit\\reg.exe");
        if (regExe.exists()) {
            reg = regExe.getAbsolutePath();
            return reg;
        }
        reg = new ExecutableFinder().find("reg.exe");
        if (reg != null) {
            return reg;
        }
        LOG.severe("OS Version: " + System.getProperty("os.version"));
        throw new WindowsRegistryException("Couldn't find reg.exe!\nPlease download it from Microsoft and install it in a standard location.\nSee here for details: http://wiki.openqa.org/display/SRC/Windows+Registry+Support");
    }

    public static boolean isRegExeVersion1() {
        if (regVersion1 != null) {
            return regVersion1;
        }
        String output = WindowsUtils.executeCommand(WindowsUtils.findReg(), "/?");
        boolean version1 = output.indexOf("version 1.0") != -1;
        regVersion1 = version1;
        return version1;
    }

    public static Class<?> discoverRegistryKeyType(String key) {
        if (!WindowsUtils.doesRegistryValueExist(key)) {
            return null;
        }
        RegKeyValue r = new RegKeyValue(key);
        String output = WindowsUtils.runRegQuery(key);
        Pattern pat = WindowsUtils.isRegExeVersion1() ? Pattern.compile("\\s*(REG_\\S+)") : Pattern.compile("\\Q" + r.value + "\\E\\s+(REG_\\S+)\\s+(.*)");
        Matcher m3 = pat.matcher(output);
        if (!m3.find()) {
            throw new WindowsRegistryException("Output didn't look right: " + output);
        }
        String type = m3.group(1);
        if ("REG_SZ".equals(type) || "REG_EXPAND_SZ".equals(type)) {
            return String.class;
        }
        if ("REG_DWORD".equals(type)) {
            return Integer.TYPE;
        }
        throw new WindowsRegistryException("Unknown type: " + type);
    }

    public static String readStringRegistryValue(String key) {
        RegKeyValue r = new RegKeyValue(key);
        String output = WindowsUtils.runRegQuery(key);
        Pattern pat = WindowsUtils.isRegExeVersion1() ? Pattern.compile("\\s*(REG_\\S+)\\s+\\Q" + r.value + "\\E\\s+(.*)") : Pattern.compile("\\Q" + r.value + "\\E\\s+(REG_\\S+)\\s+(.*)");
        Matcher m3 = pat.matcher(output);
        if (!m3.find()) {
            throw new WindowsRegistryException("Output didn't look right: " + output);
        }
        String type = m3.group(1);
        if (!"REG_SZ".equals(type) && !"REG_EXPAND_SZ".equals(type)) {
            throw new WindowsRegistryException(r.value + " was not a REG_SZ or a REG_EXPAND_SZ (String): " + type);
        }
        return m3.group(2);
    }

    public static int readIntRegistryValue(String key) {
        RegKeyValue r = new RegKeyValue(key);
        String output = WindowsUtils.runRegQuery(key);
        Pattern pat = WindowsUtils.isRegExeVersion1() ? Pattern.compile("\\s*(REG_\\S+)\\s+\\Q" + r.value + "\\E\\s+(.*)") : Pattern.compile("\\Q" + r.value + "\\E\\s+(REG_\\S+)\\s+0x(.*)");
        Matcher m3 = pat.matcher(output);
        if (!m3.find()) {
            throw new WindowsRegistryException("Output didn't look right: " + output);
        }
        String type = m3.group(1);
        if (!"REG_DWORD".equals(type)) {
            throw new WindowsRegistryException(r.value + " was not a REG_DWORD (int): " + type);
        }
        String strValue = m3.group(2);
        int value = WindowsUtils.isRegExeVersion1() ? Integer.parseInt(strValue) : Integer.parseInt(strValue, 16);
        return value;
    }

    public static boolean readBooleanRegistryValue(String key) {
        RegKeyValue r = new RegKeyValue(key);
        int value = WindowsUtils.readIntRegistryValue(key);
        if (0 == value) {
            return false;
        }
        if (1 == value) {
            return true;
        }
        throw new WindowsRegistryException(r.value + " was not either 0 or 1: " + value);
    }

    public static boolean doesRegistryValueExist(String key) {
        ArrayList<String> args = Lists.newArrayList();
        args.add("query");
        if (WindowsUtils.isRegExeVersion1()) {
            args.add(key);
        } else {
            RegKeyValue r = new RegKeyValue(key);
            args.add(r.key);
            args.add("/v");
            args.add(r.value);
        }
        try {
            WindowsUtils.executeCommand(WindowsUtils.findReg(), args.toArray(new String[args.size()]));
            return true;
        }
        catch (WindowsRegistryException e) {
            return false;
        }
    }

    public static void writeStringRegistryValue(String key, String data) throws WindowsRegistryException {
        ArrayList<String> args = new ArrayList<String>();
        if (WindowsUtils.isRegExeVersion1()) {
            if (WindowsUtils.doesRegistryValueExist(key)) {
                args.add("update");
            } else {
                args.add("add");
            }
            args.add(key + "=" + data);
        } else {
            args.add("add");
            RegKeyValue r = new RegKeyValue(key);
            args.add(r.key);
            args.add("/v");
            args.add(r.value);
            args.add("/d");
            args.add(data);
            args.add("/f");
        }
        WindowsUtils.executeCommand(WindowsUtils.findReg(), args.toArray(new String[args.size()]));
    }

    private static String executeCommand(String commandName, String ... args) {
        CommandLine cmd = new CommandLine(commandName, args);
        cmd.execute();
        String output = cmd.getStdOut();
        if (!cmd.isSuccessful()) {
            throw new WindowsRegistryException("exec return code " + cmd.getExitCode() + ": " + output);
        }
        return output;
    }

    public static void writeIntRegistryValue(String key, int data) {
        ArrayList<String> args = new ArrayList<String>();
        if (WindowsUtils.isRegExeVersion1()) {
            if (WindowsUtils.doesRegistryValueExist(key)) {
                args.add("update");
                args.add(key + "=" + Integer.toString(data));
            } else {
                args.add("add");
                args.add(key + "=" + Integer.toString(data));
                args.add("REG_DWORD");
            }
        } else {
            args.add("add");
            RegKeyValue r = new RegKeyValue(key);
            args.add(r.key);
            args.add("/v");
            args.add(r.value);
            args.add("/t");
            args.add("REG_DWORD");
            args.add("/d");
            args.add(Integer.toString(data));
            args.add("/f");
        }
        WindowsUtils.executeCommand(WindowsUtils.findReg(), args.toArray(new String[args.size()]));
    }

    public static void writeBooleanRegistryValue(String key, boolean data) {
        WindowsUtils.writeIntRegistryValue(key, data ? 1 : 0);
    }

    public static void deleteRegistryValue(String key) {
        ArrayList<String> args = new ArrayList<String>();
        if (WindowsUtils.isRegExeVersion1()) {
            args.add("delete");
            args.add(key);
            args.add("/FORCE");
        } else {
            RegKeyValue r = new RegKeyValue(key);
            args.add("delete");
            args.add(r.key);
            args.add("/v");
            args.add(r.value);
            args.add("/f");
        }
        WindowsUtils.executeCommand(WindowsUtils.findReg(), args.toArray(new String[args.size()]));
    }

    private static String runRegQuery(String key) {
        ArrayList<String> args = new ArrayList<String>();
        args.add("query");
        if (WindowsUtils.isRegExeVersion1()) {
            args.add(key);
        } else {
            RegKeyValue r = new RegKeyValue(key);
            args.add(r.key);
            args.add("/v");
            args.add(r.value);
        }
        return WindowsUtils.executeCommand(WindowsUtils.findReg(), args.toArray(new String[args.size()]));
    }

    public static boolean thisIsWindows() {
        return THIS_IS_WINDOWS;
    }

    private static class RegKeyValue {
        private String key;
        private String value;

        public RegKeyValue(String path) {
            int i = path.lastIndexOf(92);
            this.key = path.substring(0, i);
            this.value = path.substring(i + 1);
        }
    }
}

