/*
 * Decompiled with CFR 0.152.
 */
package org.webbitserver.stub;

import java.net.HttpCookie;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.webbitserver.HttpRequest;
import org.webbitserver.helpers.InboundCookieParser;
import org.webbitserver.helpers.QueryParameters;
import org.webbitserver.stub.StubDataHolder;

public class StubHttpRequest
extends StubDataHolder
implements HttpRequest {
    private String uri = "/";
    private String method = "GET";
    private List<Map.Entry<String, String>> headers = new ArrayList<Map.Entry<String, String>>();
    private SocketAddress remoteAddress = new InetSocketAddress("localhost", 0);
    private Object id = "StubID";
    private long timestamp = 0L;
    private String body;

    public StubHttpRequest() {
    }

    public StubHttpRequest(String uri) {
        this.uri = uri;
    }

    @Override
    public String uri() {
        return this.uri;
    }

    @Override
    public StubHttpRequest uri(String uri) {
        this.uri = uri;
        return this;
    }

    @Override
    public String header(String name) {
        for (Map.Entry<String, String> header : this.headers) {
            if (!header.getKey().equals(name)) continue;
            return header.getValue();
        }
        return null;
    }

    @Override
    public boolean hasHeader(String name) {
        for (Map.Entry<String, String> header : this.headers) {
            if (!header.getKey().equals(name)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<HttpCookie> cookies() {
        return InboundCookieParser.parse(this.headers("Cookie"));
    }

    @Override
    public HttpCookie cookie(String name) {
        for (HttpCookie cookie : this.cookies()) {
            if (!cookie.getName().equals(name)) continue;
            return cookie;
        }
        return null;
    }

    @Override
    public String queryParam(String key) {
        return new QueryParameters(URI.create(this.uri()).getQuery()).first(key);
    }

    @Override
    public List<String> queryParams(String key) {
        return new QueryParameters(URI.create(this.uri()).getQuery()).all(key);
    }

    @Override
    public Set<String> queryParamKeys() {
        return new QueryParameters(URI.create(this.uri()).getQuery()).keys();
    }

    @Override
    public String postParam(String key) {
        return new QueryParameters(this.body()).first(key);
    }

    @Override
    public List<String> postParams(String key) {
        return new QueryParameters(this.body()).all(key);
    }

    @Override
    public Set<String> postParamKeys() {
        return new QueryParameters(this.body()).keys();
    }

    @Override
    public String cookieValue(String name) {
        HttpCookie cookie = this.cookie(name);
        return cookie == null ? null : cookie.getValue();
    }

    @Override
    public List<String> headers(String name) {
        ArrayList<String> result = new ArrayList<String>();
        for (Map.Entry<String, String> header : this.headers) {
            if (!header.getKey().equals(name)) continue;
            result.add(header.getValue());
        }
        return result;
    }

    @Override
    public List<Map.Entry<String, String>> allHeaders() {
        return this.headers;
    }

    @Override
    public String method() {
        return this.method;
    }

    @Override
    public String body() {
        return this.body;
    }

    @Override
    public byte[] bodyAsBytes() {
        return this.body.getBytes();
    }

    public StubHttpRequest body(String body) {
        this.body = body;
        return this;
    }

    public StubHttpRequest method(String method) {
        this.method = method;
        return this;
    }

    public StubHttpRequest header(String name, String value) {
        this.headers.add(new AbstractMap.SimpleEntry<String, String>(name, value));
        return this;
    }

    @Override
    public StubHttpRequest data(String key, Object value) {
        super.data(key, value);
        return this;
    }

    @Override
    public SocketAddress remoteAddress() {
        return this.remoteAddress;
    }

    @Override
    public Object id() {
        return this.id;
    }

    public StubHttpRequest id(Object id) {
        this.id = id;
        return this;
    }

    @Override
    public long timestamp() {
        return this.timestamp;
    }

    public StubHttpRequest timestamp(long timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    public StubHttpRequest remoteAddress(SocketAddress remoteAddress) {
        this.remoteAddress = remoteAddress;
        return this;
    }
}

