/*
 * Decompiled with CFR 0.152.
 */
package com.auto.framework.operation.commmand;

import com.auto.framework.operation.OpResult;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CommandResult
implements OpResult {
    private static final long serialVersionUID = 1L;
    private final int exitStatus;
    private final List<String> lstStdOut = new ArrayList<String>();
    private final List<String> lstStdErr = new ArrayList<String>();
    private long executionTime = 0L;

    public CommandResult(int exitStatus, List<String> output, List<String> errorOutput, long lExecutionTime) {
        this.exitStatus = exitStatus;
        this.lstStdOut.addAll(output);
        this.lstStdErr.addAll(errorOutput);
        this.executionTime = lExecutionTime;
    }

    @Override
    public int getExitStatus() {
        return this.exitStatus;
    }

    @Override
    public List<String> getStdOut() {
        return Collections.unmodifiableList(this.lstStdOut);
    }

    @Override
    public List<String> getStdErr() {
        return Collections.unmodifiableList(this.lstStdErr);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ExitStatus: " + this.getExitStatus() + "\n");
        sb.append("StdOut:\n");
        sb.append(String.join((CharSequence)"\n", this.getStdOut()));
        sb.append("\nStdErr:\n");
        sb.append(String.join((CharSequence)"\n", this.getStdErr()));
        return sb.toString();
    }

    @Override
    public long getExecutionTime() {
        return this.executionTime;
    }

    @Override
    public String toStringAsOneLine() {
        return "CommandResult [exitStatus=" + this.exitStatus + ", lstStdOut=" + this.lstStdOut + ", lstStdErr=" + this.lstStdErr + ", executionTime=" + this.executionTime + "]";
    }

    public void setExecutionTime(long executionTime) {
        this.executionTime = executionTime;
    }
}

