/*
 * Decompiled with CFR 0.152.
 */
package com.auto.framework.reporter.appender;

import com.auto.framework.operation.OpResult;
import com.auto.framework.operation.commmand.CommandRequest;
import com.auto.framework.reporter.appender.TestAppender;
import com.auto.framework.reporter.iface.IOutputFileStrategy;
import java.io.File;
import java.io.FileWriter;
import java.util.Date;

public class TestFileAppender
extends TestAppender {
    public TestFileAppender(IOutputFileStrategy strategy) {
        super(strategy);
    }

    @Override
    protected void writeToFile(CommandRequest cRequest, OpResult rResult, String sFileName) {
        try {
            FileWriter fFileWriter = new FileWriter(new File(sFileName), true);
            fFileWriter.append("Command " + this.getCommandNum() + ": " + String.join((CharSequence)" ", cRequest.getCommand()) + "\n");
            fFileWriter.append("CurrentTime: " + new Date() + "\n");
            String sHost = this.getTargetHost(cRequest);
            fFileWriter.append("Hostname: " + sHost + "\n");
            fFileWriter.append("ExitStatus: " + rResult.getExitStatus() + "\n");
            fFileWriter.append("Stdout: " + String.join((CharSequence)"\n", rResult.getStdOut()) + "\n");
            fFileWriter.append("Stderr: " + String.join((CharSequence)"\n", rResult.getStdErr()) + "\n");
            fFileWriter.close();
        }
        catch (Exception e) {
            this.logMessage("failed write to file", e);
        }
    }

    private String getTargetHost(CommandRequest cRequest) {
        return cRequest.getHost();
    }

    @Override
    protected void writeToFile(String sRequest, int iStatusCode, String bOutput, String sUrl, String sFileName) {
        try {
            FileWriter fFileWriter = new FileWriter(new File(sFileName), true);
            fFileWriter.append("Url: " + sUrl + "\n");
            fFileWriter.append("Request " + this.getCommandNum() + ": " + sRequest + " \n");
            fFileWriter.append("Response: " + bOutput + "\n");
            fFileWriter.append("Response Code:" + iStatusCode + "\n");
            fFileWriter.close();
        }
        catch (Exception e) {
            this.logMessage("failed write to file", e);
        }
    }
}

