/*
 * Decompiled with CFR 0.152.
 */
package com.auto.framework.utils;

import com.auto.framework.operation.commmand.CommandResult;
import com.auto.framework.operation.commmand.TestCommandExecution;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Arrays;
import org.apache.log4j.Logger;

public class FileUtil {
    private static Logger log = Logger.getLogger(FileUtil.class);

    public static boolean delete(String path) {
        return FileUtil.delete(path, true);
    }

    public static boolean delete(String path, boolean bFollowLinks) {
        return FileUtil.delete(new File(path), bFollowLinks);
    }

    public static boolean delete(File file) {
        return FileUtil.delete(file, true);
    }

    private static boolean delete(File file, boolean bFollowLinks) {
        if (!file.exists()) {
            log.warn((Object)("delete() - file " + file.getAbsolutePath() + " doesn't exist"));
            return false;
        }
        if (!file.getParentFile().canWrite()) {
            log.warn((Object)("delete() - no write permission on file " + file.getAbsolutePath()));
            return false;
        }
        try {
            File[] fileList;
            if (FileUtil.isFollowedLink(file, bFollowLinks) && null != (fileList = file.listFiles()) && fileList.length > 0) {
                for (int i = 0; i < fileList.length; ++i) {
                    if (!fileList[i].exists()) {
                        fileList[i].delete();
                        continue;
                    }
                    if (FileUtil.delete(fileList[i], bFollowLinks)) continue;
                    log.warn((Object)("delete() - failed on " + fileList[i].getAbsolutePath()));
                    return false;
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return file.delete();
    }

    static boolean isFollowedLink(File file, boolean followLinks) throws IOException {
        return !FileUtil.isSymlink(file) || followLinks && !FileUtil.isLinkToSelf(file);
    }

    public static boolean isSymlink(File file) throws IOException {
        File canon;
        if (file == null) {
            throw new NullPointerException("File must not be null");
        }
        if (file.getParent() == null) {
            canon = file;
        } else {
            File canonDir = file.getParentFile().getCanonicalFile();
            canon = new File(canonDir, file.getName());
        }
        return !canon.getCanonicalFile().equals(canon.getAbsoluteFile());
    }

    private static boolean isLinkToSelf(File renamedFile) throws IOException {
        return Files.readSymbolicLink(renamedFile.toPath()).toString().equals(".");
    }

    public static boolean createLinkSilent(String linkName, String target) {
        return TestCommandExecution.runCommandWithoutTrace("/bin/rm", "-rf", linkName).getExitStatus() == 0 && TestCommandExecution.runCommandWithoutTrace("/bin/ln", "-s", target, linkName).getExitStatus() == 0;
    }

    public static boolean createLink(String linkName, String target) {
        return FileUtil.runCommand(new String[]{"/bin/rm", "-rf", linkName}) && FileUtil.runCommand(new String[]{"/bin/ln", "-s", target, linkName});
    }

    public static void copyFile(File in, File out) {
        try {
            FileInputStream fis = new FileInputStream(in);
            FileOutputStream fos = new FileOutputStream(out);
            byte[] buf = new byte[1024];
            int i = 0;
            while ((i = fis.read(buf)) != -1) {
                fos.write(buf, 0, i);
            }
            fis.close();
            fos.close();
            out.setLastModified(in.lastModified());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void copyFile(String in, String out) {
        FileUtil.copyFile(new File(in), new File(out));
    }

    public static void renameFile(File in, File out) throws IOException {
        if (!in.canWrite()) {
            throw new IOException("delete() - no write permission on file " + in.getAbsolutePath());
        }
        File[] fileList = in.listFiles();
        if (null != fileList && fileList.length > 0) {
            for (int i = 0; i < fileList.length; ++i) {
                FileUtil.renameFile(fileList[i], new File(out, in.getName()));
            }
        }
        in.renameTo(out);
    }

    public static String readLink(String sLink) {
        try {
            return new File(sLink).getCanonicalPath();
        }
        catch (IOException e) {
            return sLink;
        }
    }

    public static String resolveLinks(String destination) {
        try {
            File file = new File(destination + "/");
            if (!file.exists()) {
                return null;
            }
            return file.getCanonicalPath();
        }
        catch (IOException e) {
            return destination;
        }
    }

    public static boolean chmod(String path, String mode, boolean recursive) {
        String[] stringArray;
        String chmod = "/bin/chmod";
        if (recursive) {
            String[] stringArray2 = new String[4];
            stringArray2[0] = chmod;
            stringArray2[1] = "-R";
            stringArray2[2] = mode;
            stringArray = stringArray2;
            stringArray2[3] = path;
        } else {
            String[] stringArray3 = new String[3];
            stringArray3[0] = chmod;
            stringArray3[1] = mode;
            stringArray = stringArray3;
            stringArray3[2] = path;
        }
        String[] cmd = stringArray;
        return FileUtil.runCommand(cmd);
    }

    private static boolean runCommand(String[] cmd) {
        CommandResult commandResult = TestCommandExecution.runCommand(cmd);
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("runCommand() - commnad " + Arrays.toString(cmd)));
                log.debug((Object)("runCommand() - exitstatus " + commandResult.getExitStatus()));
                log.debug((Object)("runCommand() - output " + commandResult.getStdOut()));
            }
            return commandResult.getExitStatus() == 0;
        }
        catch (Exception e) {
            log.warn((Object)("runCommand() - cannot execute ln for " + Arrays.toString(cmd)), (Throwable)e);
            return false;
        }
    }

    public static String getParent(String sFile) {
        return new File(sFile).getParent();
    }

    public static void createDir(String sDirnameFull) throws IOException {
        if (!sDirnameFull.contains(File.separator)) {
            throw new IOException("Given file " + sDirnameFull + " is invalid");
        }
        new File(sDirnameFull).mkdirs();
        File file = new File(sDirnameFull + File.separator + System.currentTimeMillis() + "_test.txt");
        boolean fileCreated = file.createNewFile();
        boolean fileCanWrite = file.canWrite();
        if (fileCreated) {
            file.delete();
        }
        if (!fileCanWrite) {
            throw new IOException("Fail write to dir " + sDirnameFull);
        }
    }

    public static void setContents(String aFile, String aContents) {
        FileUtil.setContents(new File(aFile), aContents, false);
    }

    public static void setContents(File aFile, String aContents) {
        FileUtil.setContents(aFile, aContents, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setContents(File aFile, String aContents, boolean append) {
        if (aFile == null) {
            throw new IllegalArgumentException("File should not be null.");
        }
        if (!aFile.exists()) {
            throw new RuntimeException(new FileNotFoundException("File does not exist: " + aFile));
        }
        if (!aFile.isFile()) {
            throw new IllegalArgumentException("Should not be a directory: " + aFile);
        }
        if (!aFile.canWrite()) {
            throw new IllegalArgumentException("File cannot be written: " + aFile);
        }
        try (Writer output = FileUtil.getWriter(aFile, append);){
            output.write(aContents);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static Writer getWriter(File aFile, boolean append) {
        try {
            BufferedWriter output = new BufferedWriter(new FileWriter(aFile, append));
            return output;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static String getContents(File aFile) {
        StringBuilder contents = new StringBuilder();
        try {
            FileUtil.doGetContentsEx(aFile, contents);
        }
        catch (IOException ex) {
            log.error((Object)("Error reading file " + aFile.getPath()), (Throwable)ex);
        }
        return contents.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doGetContentsEx(File aFile, StringBuilder contents) throws IOException {
        try (FileReader input = new FileReader(aFile);){
            int line;
            char[] buf = new char[1024];
            while ((line = input.read(buf)) != -1) {
                contents.append(buf, 0, line);
            }
        }
    }

    public static boolean exist(String path) {
        return Files.exists(Paths.get(path, new String[0]), new LinkOption[0]);
    }
}

