/*
 * Decompiled with CFR 0.152.
 */
package com.auto.framework;

public class TestComponentData {
    private final String server;
    private final String host;
    private final String logDir;
    private final int port;
    private String installationDir;

    private TestComponentData(Builder builder) {
        this.host = builder.host;
        this.logDir = builder.logDir;
        this.port = builder.port;
        this.server = builder.server;
        this.installationDir = builder.installationDir;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getLogDir() {
        return this.logDir;
    }

    public String getServer() {
        return this.server;
    }

    public String getInstallationDir() {
        return this.installationDir;
    }

    public static class Builder {
        private int port = 0;
        private String host = "";
        private String server = "";
        public String installationDir = "";
        private String logDir = null;

        public TestComponentData build(String installationDir) {
            this.host = installationDir;
            return this.build();
        }

        public TestComponentData build(String server, String logDir) {
            this.logDir = logDir;
            this.server = server;
            return this.build();
        }

        public TestComponentData build(String host, int port, String logDir) {
            this.host = host;
            this.logDir = logDir;
            this.port = port;
            return this.build();
        }

        public TestComponentData build(String host, int port, String server, String logDir) {
            this.logDir = logDir;
            this.host = host;
            this.port = port;
            this.server = server;
            return this.build();
        }

        private TestComponentData build() {
            return new TestComponentData(this);
        }
    }
}

