/*
 * Decompiled with CFR 0.152.
 */
package com.auto.framework.runner;

import com.auto.framework.env.RegressionEnvironment;
import com.auto.framework.reporter.TestReporter;
import com.auto.framework.runner.console.progressbar.ProgressBar;
import com.auto.framework.runner.console.progressbar.ProgressBarStyle;
import com.auto.framework.runner.data.ExecutionResult;
import com.auto.framework.runner.data.ExecutionSummary;
import com.auto.framework.runner.job.TestJob;
import com.auto.framework.runner.job.TestJobResult;
import com.auto.framework.runner.job.TestJobRetryHandler;
import com.auto.framework.runner.mail.MailConfig;
import com.auto.framework.runner.mail.MailTemplateBuilder;
import com.auto.framework.runner.report.ConsoleReporter;
import com.auto.framework.runner.report.MailReporter;
import com.auto.framework.runner.testlist.TestListBuilder;
import com.auto.framework.runner.testlist.TestListBuilderImpl;
import com.google.common.collect.Lists;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.log4j.Logger;

public class TestsExecutor {
    protected static final Logger logger = Logger.getLogger(TestsExecutor.class);
    private String testsXml;
    private int pass = 0;
    private int fail = 0;
    private int fatal = 0;
    private int retryCount = 0;
    private ExecutionSummary summary;
    private final List<TestJobResult> results = Lists.newArrayList();
    private TestListBuilder testListBuilder = new TestListBuilderImpl();
    private Consumer<Exception> testFailureExceptionHandler = null;
    private Consumer<Collection<String>> beforeExecution = tests -> System.out.println("***Starting test executor");
    private Consumer<ExecutionResult> afterExecution = result -> System.out.println("***Shutting down test executor");
    private Consumer<Exception> onExecutionFailure = result -> System.out.println("**Test executed failed");
    private Consumer<ExecutionResult> onExecutionSuccess = result -> System.out.println("**Test successfully executed");
    private final List<Consumer<ExecutionResult>> reportConsumers = Lists.newArrayList();
    private boolean mailReportEnabled = false;
    private MailConfig mailConfig;
    private Function<ExecutionResult, List<MailTemplateBuilder.TableBuilder>> tablesBuilderFunction;
    private Consumer<TestJobResult> onTestCompletion;
    private Consumer<? super Path> testLogDirHandler;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(String packagePrefix) {
        this.init();
        Collection<String> tests = this.buildTests(packagePrefix);
        ExecutionResult executionResult = null;
        this.beforeExecution(tests);
        try {
            try (ProgressBar pb = new ProgressBar("", tests.size(), 1000, System.out, ProgressBarStyle.COLORFUL_UNICODE_BLOCK, "", 1L);){
                this.executeTests(tests, pb);
                executionResult = new ExecutionResult(this.summary, this.results, this.testsXml);
            }
            this.onExecutionSuccess(executionResult);
        }
        catch (Exception e) {
            this.onExecutionFailure(e);
        }
        finally {
            this.onExecutionSuccess(executionResult);
        }
        this.afterExecution(executionResult);
    }

    private void calculatePassFail() {
        this.pass += TestReporter.getErrorReporter().getPass();
        this.fail += TestReporter.getErrorReporter().getFail();
        this.fatal += TestReporter.getErrorReporter().getFatal();
    }

    private void init() {
        System.setProperty(RegressionEnvironment.REGRESSION.name(), "true");
    }

    private Collection<String> buildTests(String packagePrefix) {
        Collection<String> tests = this.testListBuilder.build(packagePrefix);
        this.testsXml = this.testListBuilder.getXmlString(tests);
        return tests;
    }

    private void executeTests(Collection<String> tests, ProgressBar pb) {
        for (String test : tests) {
            pb.step();
            TestJob testJob = new TestJob(test, this.testFailureExceptionHandler);
            TestJobResult result = new TestJobRetryHandler().doWithRetry(this.retryCount + 1, testJob);
            this.results.add(result);
            this.onTestCompletion(result);
        }
        this.summary = new ExecutionSummary(this.pass, this.fail, this.fatal);
    }

    private void onTestCompletion(TestJobResult result) {
        this.calculatePassFail();
        this.handleLogFile();
        if (null != this.onTestCompletion) {
            this.onTestCompletion.accept(result);
        }
    }

    private void handleLogFile() {
        if (null != this.testLogDirHandler) {
            try (Stream<Path> paths = Files.walk(Paths.get(TestReporter.getOutputDir(), new String[0]), new FileVisitOption[0]);){
                paths.forEach(this.testLogDirHandler);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void onExecutionFailure(Exception e) {
        this.onExecutionFailure.accept(e);
    }

    private void onExecutionSuccess(ExecutionResult executionResult) {
        this.report(executionResult);
        this.onExecutionSuccess.accept(executionResult);
    }

    private void beforeExecution(Collection<String> tests) {
        this.beforeExecution.accept(tests);
    }

    private void afterExecution(ExecutionResult executionResult) {
        this.afterExecution.accept(executionResult);
    }

    private void report(ExecutionResult executionResult) {
        this.reportConsumers.add(new ConsoleReporter());
        if (this.mailReportEnabled) {
            MailReporter reporter = Objects.nonNull(this.tablesBuilderFunction) ? new MailReporter(this.mailConfig, this.tablesBuilderFunction.apply(executionResult)) : new MailReporter(this.mailConfig);
            this.reportConsumers.add(reporter);
        }
        this.reportConsumers.parallelStream().forEach(consumer -> consumer.accept(executionResult));
    }

    public TestsExecutor withTestListBuilder(TestListBuilder builder) {
        this.testListBuilder = builder;
        return this;
    }

    public TestsExecutor withBeforeExecution(Consumer<Collection<String>> consumer) {
        this.beforeExecution = consumer;
        return this;
    }

    public TestsExecutor withAfterExecution(Consumer<ExecutionResult> consumer) {
        this.afterExecution = consumer;
        return this;
    }

    public TestsExecutor withTestRetryCount(int count) {
        this.retryCount = count;
        return this;
    }

    public TestsExecutor withTestFailureExceptionHandler(Consumer<Exception> exceptionHandler) {
        this.testFailureExceptionHandler = exceptionHandler;
        return this;
    }

    public TestsExecutor withOnExecutionFailure(Consumer<Exception> onFailure) {
        this.onExecutionFailure = onFailure;
        return this;
    }

    public TestsExecutor withOnExecutionSuccess(Consumer<ExecutionResult> onSuccess) {
        this.onExecutionSuccess = onSuccess;
        return this;
    }

    public TestsExecutor withEnableMail(MailConfig mailConfig) {
        this.mailConfig = mailConfig;
        this.mailReportEnabled = true;
        return this;
    }

    public TestsExecutor withMailTablesBuilder(Function<ExecutionResult, List<MailTemplateBuilder.TableBuilder>> tablesBuilderFunction) {
        this.tablesBuilderFunction = tablesBuilderFunction;
        return this;
    }

    public TestsExecutor withOnTestCompletion(Consumer<TestJobResult> onTestCompletion) {
        this.onTestCompletion = onTestCompletion;
        return this;
    }

    public TestsExecutor withLogFileHandler(Consumer<Path> testLogHandler) {
        this.testLogDirHandler = testLogHandler;
        return this;
    }
}

