/*
 * Decompiled with CFR 0.152.
 */
package com.pytsoft.cachelock;

import com.pytsoft.cachelock.core.CacheLock;
import com.pytsoft.cachelock.exception.LockFailedException;
import java.util.concurrent.TimeUnit;

public class LockSmith {
    public void lock(CacheLock lock) throws LockFailedException {
        this.lock(lock, 10000L);
    }

    public void lock(CacheLock lock, long acquireTimeout) throws LockFailedException {
        try {
            if (!lock.tryLock(acquireTimeout, TimeUnit.MILLISECONDS)) {
                throw new LockFailedException(String.format("Lock acquiring process for lock[%s] failed! Wait time out.", lock));
            }
        }
        catch (Exception e) {
            throw new LockFailedException(String.format("Lock acquiring process for lock[%s] failed! Reason:[%s]", lock, e.getMessage()), e);
        }
    }

    public void unlock(CacheLock lock) throws LockFailedException {
        try {
            lock.unlock();
        }
        catch (Exception e) {
            throw new LockFailedException(String.format("Lock release for lock[%s] failed! Reason:[%s]", lock, e.getMessage()), e);
        }
    }
}

