/*
 * Decompiled with CFR 0.152.
 */
package com.pytsoft.cachelock.connector;

import com.pytsoft.cachelock.connector.CacheClient;
import com.pytsoft.cachelock.util.KeyUtils;
import redis.clients.jedis.Jedis;

public class RedisClient
implements CacheClient {
    protected Jedis jedis;

    public RedisClient(Jedis jedis) {
        this.jedis = jedis;
    }

    @Override
    public boolean setnx(String key, String value, int expSeconds) {
        if (this.jedis.setnx(key, value) == 1L) {
            this.jedis.expire(key, expSeconds);
            return true;
        }
        return false;
    }

    @Override
    public boolean hsetnx(String key, String field, String value, int expSeconds) {
        if (this.jedis.hsetnx(key, field, value) == 1L) {
            return true;
        }
        String lockValue = this.hget(key, field);
        long expTime = KeyUtils.parseTime(lockValue);
        if (System.currentTimeMillis() - expTime > (long)(expSeconds * 1000)) {
            this.hdel(key, field);
            return this.jedis.hsetnx(key, field, value) == 1L;
        }
        return false;
    }

    @Override
    public String get(String key) {
        return this.jedis.get(key);
    }

    @Override
    public String hget(String key, String field) {
        return this.jedis.hget(key, field);
    }

    @Override
    public void del(String key) {
        this.jedis.del(key);
    }

    @Override
    public void hdel(String key, String field) {
        this.jedis.hdel(key, new String[]{field});
    }
}

