/*
 * Decompiled with CFR 0.152.
 */
package com.pytsoft.cachelock.connector;

import com.pytsoft.cachelock.connector.CacheClient;
import com.pytsoft.cachelock.util.KeyUtils;
import redis.clients.jedis.JedisCluster;

public class RedisClusterClient
implements CacheClient {
    protected JedisCluster cluster;

    public RedisClusterClient(JedisCluster cluster) {
        this.cluster = cluster;
    }

    @Override
    public boolean setnx(String key, String value, int expSeconds) {
        if (this.cluster.setnx(key, value) == 1L) {
            this.cluster.expire(key, expSeconds);
        }
        return false;
    }

    @Override
    public boolean hsetnx(String key, String field, String value, int expSeconds) {
        if (this.cluster.hsetnx(key, field, value) == 1L) {
            return true;
        }
        String lockValue = this.hget(key, field);
        long expTime = KeyUtils.parseTime(lockValue);
        if (System.currentTimeMillis() - expTime > (long)(expSeconds * 1000)) {
            this.hdel(key, field);
            return this.cluster.hsetnx(key, field, value) == 1L;
        }
        return false;
    }

    @Override
    public String get(String key) {
        return this.cluster.get(key);
    }

    @Override
    public String hget(String key, String field) {
        return this.cluster.hget(key, field);
    }

    @Override
    public void del(String key) {
        this.cluster.del(key);
    }

    @Override
    public void hdel(String key, String field) {
        this.cluster.hdel(key, new String[]{field});
    }
}

