/*
 * Decompiled with CFR 0.152.
 */
package com.qa.automation.utils.java.utils.common;

import com.qa.automation.utils.java.utils.common.FileOprs;
import com.qa.automation.utils.java.utils.common.StringOprs;
import java.util.concurrent.TimeUnit;

public class JavaOprs {
    public void sleepInSeconds(long seconds) {
        this.sleepInMilliseconds(TimeUnit.SECONDS.toMillis(seconds));
    }

    public void sleepInMilliseconds(long milliseconds) {
        try {
            Thread.sleep(milliseconds);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public Boolean checkIfExistClassPath(String classPath) {
        try {
            Class.forName(classPath);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public String getThisProjectDirectoryPath() {
        return System.getProperty("user.dir");
    }

    public String getThisProjectParentDirectoryPath() {
        return new FileOprs().getParentDirectoryPathFromFilePath(this.getThisProjectDirectoryPath());
    }

    public String findFileBackwardsAndGetAbsoluteFilePath(String fileName) {
        return new FileOprs().findFileBackwardsAndGetAbsoluteFilePath(this.getThisProjectDirectoryPath(), fileName);
    }

    public String getClassPackageNameAcronym(String fullClassName) {
        StringOprs stringOprs = new StringOprs();
        String classNameAcronym = null;
        String[] packageNames = null;
        int packageNamesLenght = 0;
        if (!stringOprs.isEmptyOrNull(fullClassName)) {
            packageNames = fullClassName.split("\\.");
            packageNamesLenght = packageNames.length;
        }
        if (packageNames != null) {
            for (int i = 0; i < packageNamesLenght - 1; ++i) {
                classNameAcronym = i == 0 ? packageNames[i].substring(0, 1) : classNameAcronym + "." + packageNames[i].substring(0, 1);
            }
        }
        return classNameAcronym;
    }
}

