/*
 * Decompiled with CFR 0.152.
 */
package com.qa.automation.utils.java.utils.aws.authentication;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicSessionCredentials;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.Predicate;
import com.qa.automation.utils.java.utils.common.FileOprs;
import com.qa.automation.utils.java.utils.exception.GenericRuntimeException;
import com.qa.automation.utils.java.utils.json.JsonOprs;

public class AwsAuthentication {
    private static final String DEFAULT_AWS_CREDENTIALS_FILE_NAME = "AwsCredentials.json";
    private String awsCredentialsFilePath;
    private String awsAccessKey;
    private String awsSecretKey;
    private String sessionToken;
    private BasicSessionCredentials basicSessionCredentials;
    private AWSStaticCredentialsProvider awsStaticCredentialsProvider;

    public AwsAuthentication(String awsCredentialsFilePath) {
        this.awsCredentialsFilePath = awsCredentialsFilePath;
        this.getCredentialValues();
        this.startConnection();
    }

    public AwsAuthentication() {
        this.awsCredentialsFilePath = new FileOprs().tryFindFileAndReturnPath(DEFAULT_AWS_CREDENTIALS_FILE_NAME);
        this.getCredentialValues();
        this.startConnection();
    }

    private void getCredentialValues() {
        if (this.awsCredentialsFilePath == null) {
            throw new GenericRuntimeException("The AWS credentials file was not found");
        }
        DocumentContext documentContext = new JsonOprs().getDocumentContext(this.awsCredentialsFilePath);
        this.awsAccessKey = (String)documentContext.read("$.awsAccessKey", new Predicate[0]);
        this.awsSecretKey = (String)documentContext.read("$.awsSecretKey", new Predicate[0]);
        this.sessionToken = (String)documentContext.read("$.sessionToken", new Predicate[0]);
    }

    private void startConnection() {
        this.basicSessionCredentials = new BasicSessionCredentials(this.awsAccessKey, this.awsSecretKey, this.sessionToken);
        this.awsStaticCredentialsProvider = new AWSStaticCredentialsProvider((AWSCredentials)this.basicSessionCredentials);
    }

    public String getAwsAccessKey() {
        return this.awsAccessKey;
    }

    public String getAwsSecretKey() {
        return this.awsSecretKey;
    }

    public String getSessionToken() {
        return this.sessionToken;
    }

    public BasicSessionCredentials getBasicSessionCredentials() {
        return this.basicSessionCredentials;
    }

    public AWSStaticCredentialsProvider getAwsStaticCredentialsProvider() {
        return this.awsStaticCredentialsProvider;
    }
}

