/*
 * Decompiled with CFR 0.152.
 */
package com.qa.automation.utils.java.utils.jms;

import java.util.Hashtable;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.TextMessage;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class Sender {
    private String msgID;

    public Sender(String initialContextFactory, String providerURL, String queueConnectionFactory, String queueRequest, String messageRequest) throws NamingException, JMSException {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", initialContextFactory);
        env.put("java.naming.provider.url", providerURL);
        InitialContext ctx = new InitialContext(env);
        Queue queue = (Queue)ctx.lookup(queueRequest);
        QueueConnectionFactory connFactory = (QueueConnectionFactory)ctx.lookup(queueConnectionFactory);
        QueueConnection queueConn = connFactory.createQueueConnection();
        QueueSession queueSession = queueConn.createQueueSession(false, 3);
        QueueSender queueSender = queueSession.createSender(queue);
        queueSender.setDeliveryMode(1);
        TextMessage message = queueSession.createTextMessage(messageRequest);
        queueSender.send((Message)message);
        this.msgID = message.getJMSMessageID().substring(4, message.getJMSMessageID().length() - 1);
        queueConn.close();
    }

    public String getMsgID() {
        return this.msgID;
    }
}

