/*
 * Decompiled with CFR 0.152.
 */
package com.qa.automation.utils.java.utils.logger;

import ch.qos.logback.classic.AsyncAppender;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.core.rolling.RollingFileAppender;
import com.qa.automation.utils.java.utils.common.DateTimeOprs;
import com.qa.automation.utils.java.utils.common.FileOprs;
import com.qa.automation.utils.java.utils.common.JavaOprs;
import com.qa.automation.utils.java.utils.common.StringOprs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class LogManager
implements Runnable {
    private static final String REGEX_JAVA_UTILS_PACKAGE_NAME_TO_SKIP = "co\\.com\\.java\\.utils.*";
    private static final String DEFAULT_LOG_DIRECTORY_NAME = "logs";
    private static final String EXECUTION_TIME_STAMP_FORMAT = "yyyyMMdd_HHmmss";
    private static String defaultLogFileName;
    private static final String DEFAULT_LOG_FILE_EXTENSION = ".log";
    private static final String ASYNC = "ASYNC";
    private static final String FILE_ROLLING = "FILE-ROLLING-";
    private static final String LOGBACK_LOG_DIRECTORY_PATH = "logback.log.directory.path";
    private static final String LOGBACK_LOG_FILE_NAME = "logback.log.file.name";
    private static final String LOGBACK_LOG_FILE_EXTENSION = "logback.log.file.extension";
    private String regexOfPackageNamesToSkip = this.getClass().getName() + "|java\\.lang\\.Thread";
    public String logDirectoryPath;
    public String logFileName;
    public String logFileExtension;
    public String logFilePath;
    public String currentClassName;
    public String currentMethodName;
    private boolean loggerFactoryFlag = true;
    public static Logger logger;
    private FileOprs fileOprs = new FileOprs();
    private StringOprs stringOprs = new StringOprs();
    private JavaOprs javaOprs = new JavaOprs();

    public LogManager() {
        this.setDefaultLogFileName();
        this.setupLogger(this.fileOprs.normalizePath(this.javaOprs.getThisProjectDirectoryPath(), DEFAULT_LOG_DIRECTORY_NAME), defaultLogFileName, DEFAULT_LOG_FILE_EXTENSION);
    }

    public LogManager(String logDirectoryPath) {
        this.setDefaultLogFileName();
        this.setupLogger(logDirectoryPath, defaultLogFileName, DEFAULT_LOG_FILE_EXTENSION);
    }

    public LogManager(String logDirectoryPath, String logFileName) {
        this.setupLogger(logDirectoryPath, logDirectoryPath, DEFAULT_LOG_FILE_EXTENSION);
    }

    public LogManager(String logDirectoryPath, String logFileName, String logFileExtension) {
        this.setupLogger(logDirectoryPath, logDirectoryPath, logDirectoryPath);
    }

    private void setupLogger(String logDirectoryPath, String logFileName, String logFileExtension) {
        if (this.getLoggerContext() == null || !this.stringOprs.evaluateRegex(REGEX_JAVA_UTILS_PACKAGE_NAME_TO_SKIP, this.getCallerClassFullName(), false)) {
            this.logDirectoryPath = logDirectoryPath;
            this.logFileName = logFileName;
            this.logFileExtension = logFileExtension;
            this.setSystemProperties();
            this.setLogFilePathInRuntime(this.setLogFilePath());
            this.loadThisClass();
        } else {
            this.regexOfPackageNamesToSkip = this.regexOfPackageNamesToSkip + "|" + REGEX_JAVA_UTILS_PACKAGE_NAME_TO_SKIP;
            this.loggerFactoryFlag = false;
            this.getSystemProperties();
        }
    }

    public LoggerContext getLoggerContext() {
        LoggerContext loggerContext;
        try {
            loggerContext = ((ch.qos.logback.classic.Logger)logger).getLoggerContext();
        }
        catch (Exception e) {
            loggerContext = null;
        }
        return loggerContext;
    }

    private void setLogFilePathInRuntime(String logFilePath) {
        LoggerContext loggerContext = this.getLoggerContext();
        if (loggerContext != null) {
            ch.qos.logback.classic.Logger logger = loggerContext.getLogger(this.getCallerClassPackageFirstName());
            AsyncAppender asyncAppender = (AsyncAppender)logger.getAppender(ASYNC);
            try {
                RollingFileAppender rollingFileAppender = (RollingFileAppender)asyncAppender.getAppender(FILE_ROLLING + this.logFileName);
                rollingFileAppender.setFile(logFilePath);
                rollingFileAppender.openFile(logFilePath);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private String setLogFilePath() {
        this.logFilePath = this.fileOprs.normalizePath(this.logDirectoryPath, this.logFileName + this.logFileExtension);
        return this.logFilePath;
    }

    private void setDefaultLogFileName() {
        if (this.stringOprs.isEmptyOrNull(defaultLogFileName)) {
            defaultLogFileName = new DateTimeOprs().getCurrentTime(EXECUTION_TIME_STAMP_FORMAT);
        }
    }

    private void setSystemProperties() {
        System.setProperty("logback.loggger.name", this.getCallerClassPackageFirstName());
        if (this.logDirectoryPath != null) {
            System.setProperty(LOGBACK_LOG_DIRECTORY_PATH, this.logDirectoryPath);
        }
        if (this.logFileName != null) {
            System.setProperty(LOGBACK_LOG_FILE_NAME, this.logFileName);
        }
        if (this.logFileExtension != null) {
            System.setProperty(LOGBACK_LOG_FILE_EXTENSION, this.logFileExtension);
        }
    }

    private void getSystemProperties() {
        this.logDirectoryPath = System.getProperty(LOGBACK_LOG_DIRECTORY_PATH);
        this.logFileName = System.getProperty(LOGBACK_LOG_FILE_NAME);
        this.logFileExtension = System.getProperty(LOGBACK_LOG_FILE_EXTENSION);
        this.setLogFilePath();
    }

    @Override
    public void run() {
        this.loggerFactoryFlag = false;
        MDC.put((String)LOGBACK_LOG_DIRECTORY_PATH, (String)this.logDirectoryPath);
        MDC.put((String)LOGBACK_LOG_FILE_NAME, (String)this.logFileName);
        this.info("Logger started: " + this.logFilePath);
    }

    public void reset() {
        MDC.remove((String)LOGBACK_LOG_FILE_NAME);
    }

    private void startLogger(String className) {
        try {
            logger = LoggerFactory.getLogger(Class.forName(className));
            if (this.loggerFactoryFlag) {
                this.run();
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    public String getLogDirectoryPath() {
        return this.logDirectoryPath;
    }

    public String getLogFilePath() {
        return this.logFilePath;
    }

    public Logger getLoggerInstance() {
        return logger;
    }

    public String getCurrentClassMethodName() {
        return this.currentMethodName;
    }

    public void setCurrentClassName(String className) {
        this.currentClassName = className;
    }

    public String getCurrentClassName() {
        return this.currentClassName;
    }

    public void loadThisClass() {
        this.currentClassName = this.getCallerClassFullName();
        this.currentMethodName = this.getCallerClassMethodName();
        this.startLogger(this.currentClassName);
    }

    public void loadClass(String className, String methodName) {
        this.currentClassName = className;
        this.currentMethodName = methodName;
        this.startLogger(className);
    }

    public void loadClass(String className) {
        this.loadClass(className, null);
    }

    public String getCallerClassFullName() {
        return this.getStackTraceElement().getClassName();
    }

    public String getCallerClassSimpleName() {
        String className = this.getCallerClassFullName();
        return className.substring(className.lastIndexOf(".") + 1, className.length());
    }

    public String getCallerClassMethodName() {
        return this.getStackTraceElement().getMethodName();
    }

    public String getCallerClassPackageFullName() {
        String callerFullClassName = this.getCallerClassFullName();
        return callerFullClassName.substring(0, callerFullClassName.lastIndexOf("."));
    }

    public String getCallerClassPackageFirstName() {
        String callerClassPackageFullName = this.getCallerClassPackageFullName();
        return callerClassPackageFullName.substring(0, callerClassPackageFullName.indexOf("."));
    }

    public void printStackTrace() {
        System.out.println(this.getStackTraceString());
    }

    public String getStackTraceString() {
        String stackTraceString = "";
        StackTraceElement[] stackTraceElements = Thread.currentThread().getStackTrace();
        int stackTraceElementsLength = stackTraceElements.length;
        for (int i = 0; i < stackTraceElementsLength; ++i) {
            stackTraceString = stackTraceElementsLength - 1 > i ? stackTraceString + stackTraceElements[i] + "\r\n" : stackTraceString + stackTraceElements[i];
        }
        return stackTraceString;
    }

    public StackTraceElement getStackTraceElement() {
        StackTraceElement[] stackTraceElements;
        StackTraceElement stackTraceElement = null;
        for (StackTraceElement element : stackTraceElements = Thread.currentThread().getStackTrace()) {
            String elementClassName = element.getClassName();
            if (this.stringOprs.evaluateRegex(this.regexOfPackageNamesToSkip, elementClassName, false)) continue;
            stackTraceElement = element;
            break;
        }
        return stackTraceElement;
    }

    private String buildLogMessage(String message) {
        String methodName = this.getStackTraceElement().getMethodName();
        String lineNumber = String.valueOf(this.getStackTraceElement().getLineNumber());
        return methodName + " [" + lineNumber + "] -> " + message;
    }

    public void info(String message) {
        if (logger == null) {
            return;
        }
        logger.info(this.buildLogMessage(message));
    }

    public void warn(String message) {
        if (logger == null) {
            return;
        }
        logger.warn(this.buildLogMessage(message));
    }

    public void warn(String message, Throwable throwable) {
        if (logger == null) {
            return;
        }
        logger.warn(this.buildLogMessage(message), throwable);
    }

    public void error(String message) {
        if (logger == null) {
            return;
        }
        logger.error(this.buildLogMessage(message));
    }

    public void error(String message, Throwable throwable) {
        if (logger == null) {
            return;
        }
        logger.error(this.buildLogMessage(message), throwable);
    }

    public void debug(String message) {
        if (logger == null) {
            return;
        }
        logger.debug(this.buildLogMessage(message));
    }

    public void debug(String message, Throwable throwable) {
        if (logger == null) {
            return;
        }
        logger.debug(this.buildLogMessage(message), throwable);
    }
}

