/*
 * Decompiled with CFR 0.152.
 */
package qlc.rpc;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.List;
import qlc.mng.AccountMng;
import qlc.network.QlcException;
import qlc.utils.Helper;
import qlc.utils.MnemonicUtil;
import qlc.utils.SeedUtil;
import qlc.utils.StringUtil;

public class AccountRpc {
    public static JSONObject create(JSONArray params) {
        String seed = params.getString(0);
        Integer index = params.getInteger(1);
        if (StringUtil.isBlank(seed)) {
            throw new QlcException(1001, "Seed can`t be empty");
        }
        return AccountMng.keyPairFromSeed(Helper.hexStringToBytes(seed), index);
    }

    public static String newSeed() {
        return Helper.byteToHexString(SeedUtil.generateSeed());
    }

    public static JSONArray newAccounts(JSONArray params) {
        Integer numbers = params.getInteger(0);
        return AccountMng.newAccounts(numbers);
    }

    public static String forPublicKey(JSONArray params) {
        String publicKey = params.getString(0);
        if (StringUtil.isBlank(publicKey)) {
            throw new QlcException(1002, "Public key can`t be empty");
        }
        return AccountMng.publicKeyToAddress(Helper.hexStringToBytes(publicKey));
    }

    public static String publicKey(JSONArray params) {
        String address = params.getString(0);
        return AccountMng.addressToPublicKey(address);
    }

    public static boolean validate(JSONArray params) {
        String address = params.getString(0);
        return AccountMng.isValidAddress(address);
    }

    public static String seedToMnemonics(JSONArray params) {
        String seed = params.getString(0);
        if (StringUtil.isBlank(seed)) {
            throw new QlcException(1001, "Seed can`t be empty");
        }
        List<String> mnemonicList = MnemonicUtil.seedToMnemonic(Helper.hexStringToBytes(seed), MnemonicUtil.MnemonicLanguage.ENGLISH);
        return StringUtil.join(mnemonicList.toArray(), " ");
    }

    public static String mnemonicsToSeed(JSONArray params) {
        String mnemonics = params.getString(0);
        if (StringUtil.isBlank(mnemonics)) {
            throw new QlcException(1007, "Mnemonics can`t be empty");
        }
        byte[] seed = MnemonicUtil.mnemonicToSeed(MnemonicUtil.toList(mnemonics), MnemonicUtil.MnemonicLanguage.ENGLISH);
        return Helper.byteToHexString(seed);
    }
}

