/*
 * Decompiled with CFR 0.152.
 */
package qlc.mng;

import com.alibaba.fastjson.JSONObject;
import com.google.gson.Gson;
import java.io.IOException;
import java.math.BigInteger;
import java.util.List;
import qlc.bean.Account;
import qlc.bean.Address;
import qlc.bean.Pending;
import qlc.bean.StateBlock;
import qlc.bean.Token;
import qlc.bean.TokenMeta;
import qlc.mng.AccountMng;
import qlc.mng.BlockMng;
import qlc.mng.LedgerMng;
import qlc.mng.RewardsMng;
import qlc.mng.TokenMetaMng;
import qlc.mng.TokenMng;
import qlc.mng.WalletMng;
import qlc.network.QlcClient;
import qlc.network.QlcException;
import qlc.utils.Constants;
import qlc.utils.Encodes;
import qlc.utils.Helper;
import qlc.utils.StringUtil;
import qlc.utils.WorkUtil;

public class TransactionMng {
    public static JSONObject sendBlock(QlcClient client, String from, String tokenName, String to, BigInteger amount, String sender, String receiver, String message, String data, byte[] privateKey) throws IOException {
        Token token = TokenMng.getTokenByTokenName(client, tokenName);
        TokenMeta tokenMeta = TokenMetaMng.getTokenMeta(client, token.getTokenId(), from);
        if (tokenMeta.getBalance().compareTo(amount) == -1) {
            throw new QlcException(1000, "Not enought balance(balance:" + tokenMeta.getBalance() + ", need:" + amount + ")");
        }
        StateBlock previousBlock = LedgerMng.getBlockInfoByHash(client, Helper.hexStringToBytes(tokenMeta.getHeader()));
        StateBlock block = new StateBlock("Send", token.getTokenId(), from, tokenMeta.getBalance().subtract(amount), tokenMeta.getHeader(), AccountMng.addressToPublicKey(to), new Long(System.currentTimeMillis() / 1000L), tokenMeta.getRepresentative());
        if (StringUtil.isNotBlank(sender)) {
            block.setSender(sender);
        }
        if (StringUtil.isNotBlank(receiver)) {
            block.setReceiver(receiver);
        }
        if (StringUtil.isNotBlank(message)) {
            block.setMessage(message);
        } else {
            block.setMessage("0000000000000000000000000000000000000000000000000000000000000000");
        }
        if (StringUtil.isNotBlank(data)) {
            block.setData(Encodes.encodeBase64(data.getBytes()));
        }
        block.setVote(previousBlock.getVote() == null ? new BigInteger("0") : previousBlock.getVote());
        block.setNetwork(previousBlock.getNetwork() == null ? new BigInteger("0") : previousBlock.getNetwork());
        block.setStorage(previousBlock.getStorage() == null ? new BigInteger("0") : previousBlock.getStorage());
        block.setOracle(previousBlock.getOracle() == null ? new BigInteger("0") : previousBlock.getOracle());
        block.setPovHeight(previousBlock.getPovHeight() == null ? 0L : previousBlock.getPovHeight());
        if (StringUtil.isBlank(previousBlock.getExtra())) {
            block.setExtra("0000000000000000000000000000000000000000000000000000000000000000");
        } else {
            block.setExtra(previousBlock.getExtra());
        }
        byte[] hash = BlockMng.getHash(block);
        if (hash == null || hash.length == 0) {
            throw new QlcException(2000, "Parameter error for send block");
        }
        if (privateKey != null && privateKey.length == 64) {
            Address sendAddress = new Address(from, AccountMng.addressToPublicKey(from), Helper.byteToHexString(privateKey));
            String priKey = sendAddress.getPrivateKey().replace(sendAddress.getPublicKey(), "");
            byte[] signature = WalletMng.sign(hash, Helper.hexStringToBytes(priKey));
            boolean signCheck = WalletMng.verify(signature, hash, Helper.hexStringToBytes(sendAddress.getPublicKey()));
            if (!signCheck) {
                throw new QlcException(1005, "Signature verification failed");
            }
            block.setSignature(Helper.byteToHexString(signature));
            String work = WorkUtil.generateWork(Helper.hexStringToBytes(BlockMng.getRoot(block)));
            block.setWork(work);
        }
        return JSONObject.parseObject((String)new Gson().toJson((Object)block));
    }

    public static JSONObject receiveBlock(QlcClient client, StateBlock sendBlock, String receiveAddress, byte[] privateKey) throws IOException {
        List<Pending.PendingInfo> itemList;
        byte[] sendBlockHash = BlockMng.getHash(sendBlock);
        StateBlock tempBlock = LedgerMng.getBlockInfoByHash(client, sendBlockHash);
        if (tempBlock == null) {
            throw new QlcException(2003, "Send block does not exist, block hash[" + Helper.byteToHexString(sendBlockHash) + "]");
        }
        Pending.PendingInfo info = null;
        Pending pending = LedgerMng.getAccountPending(client, receiveAddress);
        if (pending != null && (itemList = pending.getInfoList()) != null && itemList.size() > 0) {
            Pending.PendingInfo tempInfo = null;
            for (int i = 0; i < itemList.size(); ++i) {
                tempInfo = itemList.get(i);
                if (tempInfo.getHash().equals(Helper.byteToHexString(sendBlockHash))) {
                    info = tempInfo;
                    break;
                }
                tempInfo = null;
            }
        }
        if (info == null) {
            throw new QlcException(2005, "Pending not found");
        }
        if ("ContractSend".equals(sendBlock.getType()) && "d614bb9d5e20ad063316ce091148e77c99136c6194d55c7ecc7ffa9620dbcaeb".equals(sendBlock.getLink())) {
            StateBlock receiveBlock = RewardsMng.getReceiveRewardBlock(client, sendBlockHash);
            return JSONObject.parseObject((String)new Gson().toJson((Object)receiveBlock));
        }
        String tempReceiveAddress = AccountMng.publicKeyToAddress(Helper.hexStringToBytes(sendBlock.getLink()));
        if (!tempReceiveAddress.equals(receiveAddress)) {
            throw new QlcException(2000, "Parameter error for send block, receive address is [" + tempReceiveAddress + "]");
        }
        if (!"Send".equals(sendBlock.getType())) {
            throw new QlcException(2002, "The block is not send block, block hash[" + Helper.byteToHexString(sendBlockHash) + "]");
        }
        TokenMeta tokenMeta = TokenMetaMng.getTokenMeta(client, sendBlock.getToken(), receiveAddress);
        boolean has = false;
        if (tokenMeta != null) {
            has = true;
        }
        StateBlock receiveBlock = new StateBlock();
        if (has) {
            StateBlock previousBlock = LedgerMng.getBlockInfoByHash(client, Helper.hexStringToBytes(tokenMeta.getHeader()));
            receiveBlock.setType("Receive");
            receiveBlock.setAddress(receiveAddress);
            receiveBlock.setBalance(tokenMeta.getBalance().add(info.getAmount()));
            receiveBlock.setVote(previousBlock.getVote());
            receiveBlock.setNetwork(previousBlock.getNetwork());
            receiveBlock.setStorage(previousBlock.getStorage());
            receiveBlock.setOracle(previousBlock.getOracle());
            receiveBlock.setPrevious(tokenMeta.getHeader());
            receiveBlock.setLink(Helper.byteToHexString(sendBlockHash));
            receiveBlock.setRepresentative(tokenMeta.getRepresentative());
            receiveBlock.setToken(tokenMeta.getType());
            receiveBlock.setExtra("0000000000000000000000000000000000000000000000000000000000000000");
            receiveBlock.setTimestamp(new Long(System.currentTimeMillis() / 1000L));
        } else {
            receiveBlock.setType("Open");
            receiveBlock.setAddress(receiveAddress);
            receiveBlock.setBalance(info.getAmount());
            receiveBlock.setVote(Constants.ZERO_BIG_INTEGER);
            receiveBlock.setNetwork(Constants.ZERO_BIG_INTEGER);
            receiveBlock.setStorage(Constants.ZERO_BIG_INTEGER);
            receiveBlock.setOracle(Constants.ZERO_BIG_INTEGER);
            receiveBlock.setPrevious("0000000000000000000000000000000000000000000000000000000000000000");
            receiveBlock.setLink(Helper.byteToHexString(sendBlockHash));
            receiveBlock.setRepresentative(sendBlock.getRepresentative());
            receiveBlock.setToken(sendBlock.getToken());
            receiveBlock.setExtra("0000000000000000000000000000000000000000000000000000000000000000");
            receiveBlock.setTimestamp(new Long(System.currentTimeMillis() / 1000L));
        }
        if (StringUtil.isBlank(sendBlock.getMessage())) {
            receiveBlock.setMessage("0000000000000000000000000000000000000000000000000000000000000000");
        } else {
            receiveBlock.setMessage(sendBlock.getMessage());
        }
        receiveBlock.setPovHeight(Constants.ZERO_LONG);
        if (privateKey != null && privateKey.length == 64) {
            String priKey = Helper.byteToHexString(privateKey);
            String pubKey = priKey.substring(64);
            if (!pubKey.equals(sendBlock.getLink())) {
                throw new QlcException(2004, "Address is mismatch private key");
            }
            byte[] receiveBlockHash = BlockMng.getHash(receiveBlock);
            byte[] signature = WalletMng.sign(receiveBlockHash, Helper.hexStringToBytes(priKey.replace(pubKey, "")));
            boolean signCheck = WalletMng.verify(signature, receiveBlockHash, Helper.hexStringToBytes(pubKey));
            if (!signCheck) {
                throw new QlcException(1005, "Signature verification failed");
            }
            receiveBlock.setSignature(Helper.byteToHexString(signature));
            String work = WorkUtil.generateWork(Helper.hexStringToBytes(BlockMng.getRoot(receiveBlock)));
            receiveBlock.setWork(work);
        }
        return JSONObject.parseObject((String)new Gson().toJson((Object)receiveBlock));
    }

    public static JSONObject changeBlock(QlcClient client, String address, String representative, String chainTokenHash, byte[] privateKey) throws IOException {
        Account representativeInfo = TokenMetaMng.getAccountMeta(client, representative);
        if (representativeInfo == null) {
            throw new QlcException(2006, "Invalid representative[" + representative + "]");
        }
        Account addressInfo = TokenMetaMng.getAccountMeta(client, address);
        if (addressInfo == null) {
            throw new QlcException(2007, "Account is not exist, address:[" + address + "]");
        }
        TokenMeta tokenMeta = null;
        List<TokenMeta> tokens = addressInfo.getTokens();
        for (int i = 0; i < tokens.size() && !chainTokenHash.equals((tokenMeta = tokens.get(i)).getType()); ++i) {
            tokenMeta = null;
        }
        if (tokenMeta == null) {
            throw new QlcException(2008, "Account has no chain token, address:[" + address + "]");
        }
        StateBlock previousBlock = LedgerMng.getBlockInfoByHash(client, Helper.hexStringToBytes(tokenMeta.getHeader()));
        if (previousBlock == null) {
            throw new QlcException(2009, "Token header block not found");
        }
        StateBlock changeBlock = new StateBlock();
        changeBlock.setType("Change");
        changeBlock.setAddress(address);
        changeBlock.setBalance(tokenMeta.getBalance());
        changeBlock.setVote(previousBlock.getVote());
        changeBlock.setNetwork(previousBlock.getNetwork());
        changeBlock.setStorage(previousBlock.getStorage());
        changeBlock.setOracle(previousBlock.getOracle());
        changeBlock.setPrevious(tokenMeta.getHeader());
        changeBlock.setLink("0000000000000000000000000000000000000000000000000000000000000000");
        changeBlock.setRepresentative(representative);
        changeBlock.setToken(tokenMeta.getType());
        changeBlock.setExtra("0000000000000000000000000000000000000000000000000000000000000000");
        changeBlock.setTimestamp(new Long(System.currentTimeMillis() / 1000L));
        changeBlock.setMessage("0000000000000000000000000000000000000000000000000000000000000000");
        changeBlock.setPovHeight(Constants.ZERO_LONG);
        if (privateKey != null && privateKey.length == 64) {
            String priKey = Helper.byteToHexString(privateKey);
            String pubKey = priKey.substring(64);
            if (!address.equals(AccountMng.publicKeyToAddress(Helper.hexStringToBytes(pubKey)))) {
                throw new QlcException(2004, "Address is mismatch private key");
            }
            byte[] changeBlockHash = BlockMng.getHash(changeBlock);
            byte[] signature = WalletMng.sign(changeBlockHash, Helper.hexStringToBytes(priKey.replace(pubKey, "")));
            boolean signCheck = WalletMng.verify(signature, changeBlockHash, Helper.hexStringToBytes(pubKey));
            if (!signCheck) {
                throw new QlcException(1005, "Signature verification failed");
            }
            changeBlock.setSignature(Helper.byteToHexString(signature));
            String work = WorkUtil.generateWork(Helper.hexStringToBytes(BlockMng.getRoot(changeBlock)));
            changeBlock.setWork(work);
        }
        return JSONObject.parseObject((String)new Gson().toJson((Object)changeBlock));
    }
}

