/*
 * Decompiled with CFR 0.152.
 */
package qlc.network;

import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.net.MalformedURLException;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import qlc.network.QlcException;

public class QlcHttpClient {
    private final String url;

    public QlcHttpClient(String url) throws MalformedURLException {
        this.url = url;
    }

    public JSONObject send(JSONObject params) {
        OkHttpClient client = new OkHttpClient();
        try {
            RequestBody body = RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)params.toJSONString());
            Request request = new Request.Builder().url(this.url).post(body).build();
            Response response = client.newCall(request).execute();
            if (response == null) {
                throw new QlcException(900, "Invalid response type");
            }
            int statusCode = response.code();
            if (statusCode != 200) {
                throw new QlcException(statusCode, response.code() + "");
            }
            JSONObject result = JSONObject.parseObject((String)response.body().string());
            if (result.containsKey((Object)"result") || result.containsKey((Object)"error")) {
                return result;
            }
            throw new IOException();
        }
        catch (IOException e) {
            throw new QlcException(901, e.getMessage());
        }
    }
}

