/*
 * Decompiled with CFR 0.152.
 */
package qlc.network;

import java.io.IOException;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import okio.ByteString;
import qlc.network.Message;

public class QlcWebSocketClient
extends WebSocketListener {
    private static OkHttpClient client;
    private static WebSocket socket;
    protected static String result;
    private Message message;

    public synchronized void startRequest(String url) {
        if (client == null) {
            client = new OkHttpClient();
        }
        if (socket == null) {
            Request request = new Request.Builder().url(url).build();
            socket = client.newWebSocket(request, (WebSocketListener)this);
        }
    }

    private void sendMessage(WebSocket webSocket, String params) {
        webSocket.send(params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessage(String params) {
        Class<QlcWebSocketClient> clazz = QlcWebSocketClient.class;
        synchronized (QlcWebSocketClient.class) {
            WebSocket webSocket = socket;
            // ** MonitorExit[var3_2] (shouldn't be in output)
            if (webSocket != null) {
                this.sendMessage(webSocket, params);
            }
            return;
        }
    }

    public synchronized void closeWebSocket() {
        if (socket != null) {
            socket.close(1000, "Goodbye!");
            socket = null;
        }
    }

    public synchronized void destroy() {
        if (client != null) {
            client.dispatcher().executorService().shutdown();
            client = null;
        }
    }

    public Message getMessage() {
        return this.message;
    }

    public void setMessage(Message message) {
        this.message = message;
    }

    public void http() {
        MediaType mediaType = MediaType.parse((String)"text/x-markdown; charset=utf-8");
        String requestBody = "I am Jdqm.";
        Request request = new Request.Builder().url("https://api.github.com/markdown/raw").post(RequestBody.create((MediaType)mediaType, (String)requestBody)).build();
        OkHttpClient okHttpClient = new OkHttpClient();
        okHttpClient.newCall(request).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                System.out.println("onFailure: " + e.getMessage());
            }

            public void onResponse(Call call, Response response) throws IOException {
                System.out.println(response.protocol() + " " + response.code() + " " + response.message());
                Headers headers = response.headers();
                for (int i = 0; i < headers.size(); ++i) {
                    System.out.println(headers.name(i) + ":" + headers.value(i));
                }
                System.out.println("onResponse: " + response.body().string());
            }
        });
    }

    public void onOpen(WebSocket webSocket, Response response) {
        if (this.message != null) {
            this.message.onOpen(webSocket, response);
        }
    }

    public void onMessage(WebSocket webSocket, String text) {
        result = text;
        if (this.message != null) {
            this.message.onMessage(webSocket, text);
        }
    }

    public void onMessage(WebSocket webSocket, ByteString bytes) {
        if (this.message != null) {
            this.message.onMessage(webSocket, bytes);
        }
    }

    public void onClosing(WebSocket webSocket, int code, String reason) {
        webSocket.close(1000, null);
        if (this.message != null) {
            this.message.onClosing(webSocket, code, reason);
        }
    }

    public void onClosed(WebSocket webSocket, int code, String reason) {
        if (this.message != null) {
            this.message.onClosed(webSocket, code, reason);
        }
    }

    public void onFailure(WebSocket webSocket, Throwable t, Response response) {
        t.printStackTrace();
        if (this.message != null) {
            this.message.onFailure(webSocket, t, response);
        }
    }
}

