/*
 * Decompiled with CFR 0.152.
 */
package qlc.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.SimpleTimeZone;
import java.util.TimeZone;

public class TimeUtil {
    public static String getBeijingTime() {
        return TimeUtil.getFormatedDateString(8.0f);
    }

    public static String getBangaloreTime() {
        return TimeUtil.getFormatedDateString(5.5f);
    }

    public static String getNewyorkTime() {
        return TimeUtil.getFormatedDateString(-5.0f);
    }

    public static String getFormatedDateString(float timeZoneOffset) {
        int newTime;
        String[] ids;
        if (timeZoneOffset > 13.0f || timeZoneOffset < -12.0f) {
            timeZoneOffset = 0.0f;
        }
        TimeZone timeZone = (ids = TimeZone.getAvailableIDs(newTime = (int)(timeZoneOffset * 60.0f * 60.0f * 1000.0f))).length == 0 ? TimeZone.getDefault() : new SimpleTimeZone(newTime, ids[0]);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        sdf.setTimeZone(timeZone);
        return sdf.format(new Date());
    }

    public static long getTimeSeconds(float timeZoneOffset) {
        try {
            int newTime;
            String[] ids;
            if (timeZoneOffset > 13.0f || timeZoneOffset < -12.0f) {
                timeZoneOffset = 0.0f;
            }
            TimeZone timeZone = (ids = TimeZone.getAvailableIDs(newTime = (int)(timeZoneOffset * 60.0f * 60.0f * 1000.0f))).length == 0 ? TimeZone.getDefault() : new SimpleTimeZone(newTime, ids[0]);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            sdf.setTimeZone(timeZone);
            String dateStr = sdf.format(new Date());
            Date timeZoneDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(dateStr);
            return timeZoneDate.getTime() / 1000L;
        }
        catch (ParseException e) {
            e.printStackTrace();
            return System.currentTimeMillis() / 1000L;
        }
    }
}

