package com.github.rameshl.appengine.test.enums;

import com.google.appengine.tools.development.testing.LocalDatastoreServiceTestConfig;
import com.google.appengine.tools.development.testing.LocalMemcacheServiceTestConfig;
import com.google.appengine.tools.development.testing.LocalServiceTestConfig;
import com.google.appengine.tools.development.testing.LocalTaskQueueTestConfig;
import com.google.appengine.tools.development.testing.LocalURLFetchServiceTestConfig;

import java.util.ArrayList;
import java.util.List;

/**
 * FullAuth Created by Ramesh on 7/5/18.
 */
public enum GaeServiceHelperType {

    Datastore, Queue, Memcache, Urlfetch;

    public static LocalDatastoreServiceTestConfig datastoreConfig() {
        return new LocalDatastoreServiceTestConfig().setApplyAllHighRepJobPolicy().setNoIndexAutoGen(true);
    }

    public static LocalMemcacheServiceTestConfig memcacheConfig() {
        return new LocalMemcacheServiceTestConfig();
    }

    public static LocalTaskQueueTestConfig queueConfig() {
        return new LocalTaskQueueTestConfig();
    }

    public static LocalURLFetchServiceTestConfig urlfetchConfig() {
        return new LocalURLFetchServiceTestConfig();
    }

    public static LocalServiceTestConfig[] allConfig() {
        return new LocalServiceTestConfig[]{datastoreConfig(), memcacheConfig(), queueConfig()};
    }

    public static LocalServiceTestConfig[] getConfigs(GaeServiceHelperType... types) {

        List<LocalServiceTestConfig> configs = new ArrayList<>();

        for (GaeServiceHelperType type : types) {
            configs.add(type.getConfig());
        }

        return configs.toArray(new LocalServiceTestConfig[0]);
    }

    public LocalServiceTestConfig getConfig() {
        switch (this) {
            case Datastore:
                return datastoreConfig();
            case Memcache:
                return memcacheConfig();
            case Queue:
                return queueConfig();
            case Urlfetch:
                return urlfetchConfig();
        }

        return null;
    }
}
