package com.github.rameshl.appengine.test.ofy;

import com.google.appengine.api.datastore.DatastoreService;
import com.google.appengine.api.datastore.DatastoreServiceFactory;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.EntityNotFoundException;
import com.google.appengine.tools.development.testing.LocalServiceTestConfig;

import com.github.rameshl.appengine.test.enums.GaeServiceHelperType;
import com.github.rameshl.appengine.test.gae.GaeGenericTestBase;
import com.googlecode.objectify.Key;
import com.googlecode.objectify.Objectify;
import com.googlecode.objectify.ObjectifyService;
import com.googlecode.objectify.util.Closeable;

import org.junit.After;
import org.junit.Before;

/**
 * gae-test-util Created by Ramesh on 7/6/18.
 */
public abstract class ObjectifyTestBase extends GaeGenericTestBase {

    /**
     * The Session.
     */
    protected Closeable session;

    /**
     * Instantiates a new Objectify test base.
     */
    public ObjectifyTestBase() {
        super(GaeServiceHelperType.Datastore, GaeServiceHelperType.Memcache);
    }

    /**
     * Instantiates a new Objectify test base.
     *
     * @param configs the configs
     */
    public ObjectifyTestBase(LocalServiceTestConfig... configs) {
        super(configs);
    }

    /**
     * Instantiates a new Objectify test base.
     *
     * @param types the types
     */
    public ObjectifyTestBase(GaeServiceHelperType... types) {
        super(types);
    }

    /**
     * Register entity.
     *
     * @param clazz the clazz
     */
    public static void registerEntity(Class<?>... clazz) {
        for (Class<?> c : clazz) {
            registerEntity(c);
        }
    }

    /**
     * Register entity.
     *
     * @param clazz the clazz
     */
    public static void registerEntity(Class<?> clazz) {
        ofy().factory().register(clazz);
    }

    /**
     * Ofy objectify instance
     *
     * @return the objectify
     */
    protected static Objectify ofy() {
        return ObjectifyService.ofy();
    }

    /**
     * Ofy set up.
     */
    @Before
    public void ofySetUp() {
        this.session = ObjectifyService.begin();
        registerOfyEntities();
    }

    /**
     * Ofy tear down.
     */
    @After
    public void ofyTearDown() {
        // AsyncCacheFilter.complete();
        this.session.close();
    }

    /**
     * Register ofy entities.
     */
// this method is meant to be overriden by child classes to register their entities
    public abstract void registerOfyEntities();

    /**
     * Put entity, clear session, and immediately get it.
     *
     * @param <T>    the type parameter
     * @param saveMe the save me
     * @return the t
     */
    protected <T> T putClearGet(T saveMe) {

        Key<T> key = ofy().save().entity(saveMe).now();

        try {
            Entity ent = ds().get(null, key.getRaw());
        } catch (EntityNotFoundException e) {
            throw new RuntimeException(e);
        }

        ofy().clear();
        return ofy().load().key(key).now();
    }

    /**
     * Get a DatastoreService
     *
     * @return the datastore services
     */
    protected DatastoreService ds() {
        return DatastoreServiceFactory.getDatastoreService();
    }
}
