/*
 * Decompiled with CFR 0.152.
 */
package com.github.rameshl.appengine.test.gae;

import com.github.rameshl.appengine.test.base.TestBase;
import com.github.rameshl.appengine.test.enums.GaeServiceHelperType;
import com.github.rameshl.appengine.test.model.UserInfo;
import com.google.appengine.api.utils.SystemProperty;
import com.google.appengine.tools.development.testing.LocalServiceTestConfig;
import com.google.appengine.tools.development.testing.LocalServiceTestHelper;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.junit.After;
import org.junit.Before;

public abstract class GaeGenericTestBase
extends TestBase {
    protected final LocalServiceTestHelper helper;

    public GaeGenericTestBase() {
        this(GaeServiceHelperType.values());
    }

    public GaeGenericTestBase(GaeServiceHelperType ... types) {
        this(GaeServiceHelperType.getConfigs(types));
    }

    public GaeGenericTestBase(LocalServiceTestConfig ... configs) {
        this.helper = new LocalServiceTestHelper(configs);
        SystemProperty.environment.set(SystemProperty.Environment.Value.Development);
    }

    public void setUserInfo(UserInfo userInfo) {
        this.helper.setEnvIsLoggedIn(userInfo.isLoggedIn()).setEnvIsAdmin(userInfo.isAdmin()).setEnvAuthDomain(userInfo.getAuthDomain()).setEnvEmail(userInfo.getEmail()).setEnvAttributes((Map)ImmutableMap.of((Object)"com.google.appengine.api.users.UserService.user_id_key", (Object)userInfo.getUserId()));
    }

    @Before
    public void gaeSetUp() {
        this.helper.setUp();
    }

    @After
    public void gaeTearDown() {
        this.helper.tearDown();
    }
}

