/*
 * Decompiled with CFR 0.152.
 */
package com.github.rameshl.appengine.test.model;

public class UserInfo {
    private String userId;
    private String email;
    private String authDomain;
    private boolean isAdmin;
    private boolean isLoggedIn;

    public static UserInfo createUser(String email, String userId) {
        String authDomain = email.substring(email.indexOf(64) + 1);
        return new UserInfo(userId, email, authDomain, false, true);
    }

    public static UserInfo createAdmin(String email, String userId) {
        String authDomain = email.substring(email.indexOf(64) + 1);
        return new UserInfo(userId, email, authDomain, true, true);
    }

    public static UserInfo loggedOut() {
        return new UserInfo("", "", "", false, false);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getUserId() {
        return this.userId;
    }

    public String getEmail() {
        return this.email;
    }

    public String getAuthDomain() {
        return this.authDomain;
    }

    public boolean isAdmin() {
        return this.isAdmin;
    }

    public boolean isLoggedIn() {
        return this.isLoggedIn;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setAuthDomain(String authDomain) {
        this.authDomain = authDomain;
    }

    public void setAdmin(boolean isAdmin) {
        this.isAdmin = isAdmin;
    }

    public void setLoggedIn(boolean isLoggedIn) {
        this.isLoggedIn = isLoggedIn;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UserInfo)) {
            return false;
        }
        UserInfo other = (UserInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$userId = this.getUserId();
        String other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !this$userId.equals(other$userId)) {
            return false;
        }
        String this$email = this.getEmail();
        String other$email = other.getEmail();
        if (this$email == null ? other$email != null : !this$email.equals(other$email)) {
            return false;
        }
        String this$authDomain = this.getAuthDomain();
        String other$authDomain = other.getAuthDomain();
        if (this$authDomain == null ? other$authDomain != null : !this$authDomain.equals(other$authDomain)) {
            return false;
        }
        if (this.isAdmin() != other.isAdmin()) {
            return false;
        }
        return this.isLoggedIn() == other.isLoggedIn();
    }

    protected boolean canEqual(Object other) {
        return other instanceof UserInfo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : $userId.hashCode());
        String $email = this.getEmail();
        result = result * 59 + ($email == null ? 43 : $email.hashCode());
        String $authDomain = this.getAuthDomain();
        result = result * 59 + ($authDomain == null ? 43 : $authDomain.hashCode());
        result = result * 59 + (this.isAdmin() ? 79 : 97);
        result = result * 59 + (this.isLoggedIn() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "UserInfo(userId=" + this.getUserId() + ", email=" + this.getEmail() + ", authDomain=" + this.getAuthDomain() + ", isAdmin=" + this.isAdmin() + ", isLoggedIn=" + this.isLoggedIn() + ")";
    }

    public UserInfo(String userId, String email, String authDomain, boolean isAdmin, boolean isLoggedIn) {
        this.userId = userId;
        this.email = email;
        this.authDomain = authDomain;
        this.isAdmin = isAdmin;
        this.isLoggedIn = isLoggedIn;
    }

    public UserInfo() {
    }

    public static class Builder {
        private String userId;
        private String email;
        private String authDomain;
        private boolean isAdmin;
        private boolean isLoggedIn;

        Builder() {
        }

        public Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public Builder email(String email) {
            this.email = email;
            return this;
        }

        public Builder authDomain(String authDomain) {
            this.authDomain = authDomain;
            return this;
        }

        public Builder isAdmin(boolean isAdmin) {
            this.isAdmin = isAdmin;
            return this;
        }

        public Builder isLoggedIn(boolean isLoggedIn) {
            this.isLoggedIn = isLoggedIn;
            return this;
        }

        public UserInfo build() {
            return new UserInfo(this.userId, this.email, this.authDomain, this.isAdmin, this.isLoggedIn);
        }

        public String toString() {
            return "UserInfo.Builder(userId=" + this.userId + ", email=" + this.email + ", authDomain=" + this.authDomain + ", isAdmin=" + this.isAdmin + ", isLoggedIn=" + this.isLoggedIn + ")";
        }
    }
}

