/*
 * Decompiled with CFR 0.152.
 */
package com.github.rameshl.appengine.test.ofy;

import com.github.rameshl.appengine.test.enums.GaeServiceHelperType;
import com.github.rameshl.appengine.test.gae.GaeGenericTestBase;
import com.google.appengine.api.datastore.DatastoreService;
import com.google.appengine.api.datastore.DatastoreServiceFactory;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.EntityNotFoundException;
import com.google.appengine.tools.development.testing.LocalServiceTestConfig;
import com.googlecode.objectify.Key;
import com.googlecode.objectify.Objectify;
import com.googlecode.objectify.ObjectifyService;
import com.googlecode.objectify.util.Closeable;
import org.junit.After;
import org.junit.Before;

public abstract class ObjectifyTestBase
extends GaeGenericTestBase {
    protected Closeable session;

    public ObjectifyTestBase() {
        super(GaeServiceHelperType.Datastore, GaeServiceHelperType.Memcache);
    }

    public ObjectifyTestBase(LocalServiceTestConfig ... configs) {
        super(configs);
    }

    public ObjectifyTestBase(GaeServiceHelperType ... types) {
        super(types);
    }

    public static void registerEntity(Class<?> ... clazz) {
        for (Class<?> c : clazz) {
            ObjectifyTestBase.registerEntity(c);
        }
    }

    public static void registerEntity(Class<?> clazz) {
        ObjectifyTestBase.ofy().factory().register(clazz);
    }

    protected static Objectify ofy() {
        return ObjectifyService.ofy();
    }

    @Before
    public void ofySetUp() {
        this.session = ObjectifyService.begin();
        this.registerOfyEntities();
    }

    @After
    public void ofyTearDown() {
        this.session.close();
    }

    public abstract void registerOfyEntities();

    protected <T> T putClearGet(T saveMe) {
        Key key = (Key)ObjectifyTestBase.ofy().save().entity(saveMe).now();
        try {
            Entity entity = this.ds().get(null, key.getRaw());
        }
        catch (EntityNotFoundException e) {
            throw new RuntimeException(e);
        }
        ObjectifyTestBase.ofy().clear();
        return (T)ObjectifyTestBase.ofy().load().key(key).now();
    }

    protected DatastoreService ds() {
        return DatastoreServiceFactory.getDatastoreService();
    }
}

