package com.github.rameshdev.httputils;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;

import lombok.Data;
import lombok.NonNull;
import lombok.Singular;

/**
 * The type Http request.
 */
@Data
@lombok.Builder(builderClassName = "Builder")
public class HttpRequest {

    @NonNull
    private URL url;

    private byte[] payload;

    private HttpMethod method;

    private String contentType;

    /**
     * The Headers.
     */
    @Singular
    @NonNull
    protected Map<String, String> headers;

    private FetchConfig fetchConfig;

    /**
     * Extending lombok Builder
     */
    public static class Builder {

        /**
         * Url builder.
         *
         * @param url the url
         * @return the builder
         * @throws MalformedURLException the malformed url exception
         */
        public Builder setUrl(String url) throws MalformedURLException {
            this.url = new URL(url);
            return this;
        }

        /**
         * Content type builder.
         *
         * @param type the type
         * @return the builder
         */
        public Builder setContentType(MediaType type) {
            this.contentType = type.getContentType();
            return this;
        }
    }
}
