package com.github.rameshdev.httputils;

/**
 * The type User agent helper.
 */
public class UserAgentHelper {

    /**
     * Gets user agent.
     *
     * @return the user agent
     */
    public static String getUserAgent() {
        // android
        String agent = System.getProperty("http.agent");
        if (agent != null && !agent.isEmpty()) {
            return agent;
        }

        // general
        agent = System.getProperty("user-agent");
        if (agent != null && !agent.isEmpty()) {
            return agent;
        }

        return null;
    }
}
