/*
 * Decompiled with CFR 0.152.
 */
package com.buck.common.codec;

import com.buck.common.codec.Codec;
import com.buck.common.codec.CodecDecoder;
import com.buck.common.codec.CodecEncoder;
import com.buck.common.codec.StandardCodecs;

public class Base64URL
extends Codec {
    private static final int BASELENGTH = 128;
    private static final int LOOKUPLENGTH = 64;
    private static final int TWENTYFOURBITGROUP = 24;
    private static final int EIGHTBIT = 8;
    private static final int SIXTEENBIT = 16;
    private static final int FOURBYTE = 4;
    private static final int SIGN = -128;
    private static final char PAD = '=';
    private static final byte[] base64Alphabet;
    private static final byte[] lookUpBase64Alphabet;
    private static final byte[] EMPTY_STRING;

    private static boolean isWhiteSpace(byte octet) {
        return octet == 32 || octet == 13 || octet == 10 || octet == 9;
    }

    private static boolean isPad(byte octet) {
        return octet == 61;
    }

    private static boolean isData(byte octet) {
        return (0xFF & octet) < 128 && base64Alphabet[0xFF & octet] != -1;
    }

    protected static boolean isBase64(byte octet) {
        return Base64URL.isWhiteSpace(octet) || Base64URL.isPad(octet) || Base64URL.isData(octet);
    }

    private static int removeWhiteSpace(byte[] data) {
        if (data == null) {
            return 0;
        }
        int newSize = 0;
        int len = data.length;
        for (int i = 0; i < len; ++i) {
            if (Base64URL.isWhiteSpace(data[i])) continue;
            data[newSize++] = data[i];
        }
        return newSize;
    }

    public Base64URL() {
        super("base64url", StandardCodecs.aliases_Base64URL);
    }

    @Override
    public CodecDecoder newDecoder() {
        return new Decoder(this);
    }

    @Override
    public CodecEncoder newEncoder() {
        return new Encoder(this);
    }

    static {
        int i;
        base64Alphabet = new byte[128];
        lookUpBase64Alphabet = new byte[64];
        for (i = 0; i < 128; ++i) {
            Base64URL.base64Alphabet[i] = -1;
        }
        for (i = 90; i >= 65; --i) {
            Base64URL.base64Alphabet[i] = (byte)(i - 65);
        }
        for (i = 122; i >= 97; --i) {
            Base64URL.base64Alphabet[i] = (byte)(i - 97 + 26);
        }
        for (i = 57; i >= 48; --i) {
            Base64URL.base64Alphabet[i] = (byte)(i - 48 + 52);
        }
        Base64URL.base64Alphabet[45] = 62;
        Base64URL.base64Alphabet[95] = 63;
        for (i = 0; i <= 25; ++i) {
            Base64URL.lookUpBase64Alphabet[i] = (byte)(65 + i);
        }
        i = 26;
        int j = 0;
        while (i <= 51) {
            Base64URL.lookUpBase64Alphabet[i] = (byte)(97 + j);
            ++i;
            ++j;
        }
        i = 52;
        j = 0;
        while (i <= 61) {
            Base64URL.lookUpBase64Alphabet[i] = (byte)(48 + j);
            ++i;
            ++j;
        }
        Base64URL.lookUpBase64Alphabet[62] = 45;
        Base64URL.lookUpBase64Alphabet[63] = 95;
        EMPTY_STRING = new byte[0];
    }

    private static class Encoder
    extends CodecEncoder {
        public Encoder(Codec codec) {
            super(codec);
        }

        @Override
        public byte[] encode(byte[] binary) {
            byte val1;
            byte k;
            byte l;
            byte b2;
            byte b1;
            if (binary == null) {
                return null;
            }
            int lengthDataBits = binary.length * 8;
            if (lengthDataBits == 0) {
                return EMPTY_STRING;
            }
            int fewerThan24bits = lengthDataBits % 24;
            int numberTriplets = lengthDataBits / 24;
            int numberQuartet = fewerThan24bits != 0 ? numberTriplets + 1 : numberTriplets;
            byte[] encoded = new byte[numberQuartet * 4];
            int encodedIndex = 0;
            int dataIndex = 0;
            for (int i = 0; i < numberTriplets; ++i) {
                b1 = binary[dataIndex++];
                b2 = binary[dataIndex++];
                byte b3 = binary[dataIndex++];
                l = (byte)(b2 & 0xF);
                k = (byte)(b1 & 3);
                byte val12 = (b1 & 0xFFFFFF80) == 0 ? (byte)(b1 >> 2) : (byte)(b1 >> 2 ^ 0xC0);
                byte val2 = (b2 & 0xFFFFFF80) == 0 ? (byte)(b2 >> 4) : (byte)(b2 >> 4 ^ 0xF0);
                byte val3 = (b3 & 0xFFFFFF80) == 0 ? (byte)(b3 >> 6) : (byte)(b3 >> 6 ^ 0xFC);
                encoded[encodedIndex++] = lookUpBase64Alphabet[val12];
                encoded[encodedIndex++] = lookUpBase64Alphabet[val2 | k << 4];
                encoded[encodedIndex++] = lookUpBase64Alphabet[l << 2 | val3];
                encoded[encodedIndex++] = lookUpBase64Alphabet[b3 & 0x3F];
            }
            if (fewerThan24bits == 8) {
                b1 = binary[dataIndex];
                k = (byte)(b1 & 3);
                val1 = (b1 & 0xFFFFFF80) == 0 ? (byte)(b1 >> 2) : (byte)(b1 >> 2 ^ 0xC0);
                encoded[encodedIndex++] = lookUpBase64Alphabet[val1];
                encoded[encodedIndex++] = lookUpBase64Alphabet[k << 4];
                encoded[encodedIndex++] = 61;
                encoded[encodedIndex] = 61;
            } else if (fewerThan24bits == 16) {
                b1 = binary[dataIndex];
                b2 = binary[dataIndex + 1];
                l = (byte)(b2 & 0xF);
                k = (byte)(b1 & 3);
                val1 = (b1 & 0xFFFFFF80) == 0 ? (byte)(b1 >> 2) : (byte)(b1 >> 2 ^ 0xC0);
                byte val2 = (b2 & 0xFFFFFF80) == 0 ? (byte)(b2 >> 4) : (byte)(b2 >> 4 ^ 0xF0);
                encoded[encodedIndex++] = lookUpBase64Alphabet[val1];
                encoded[encodedIndex++] = lookUpBase64Alphabet[val2 | k << 4];
                encoded[encodedIndex++] = lookUpBase64Alphabet[l << 2];
                encoded[encodedIndex] = 61;
            }
            return encoded;
        }
    }

    private static class Decoder
    extends CodecDecoder {
        public Decoder(Codec codec) {
            super(codec);
        }

        @Override
        public byte[] decode(byte[] encoded) {
            byte b4;
            byte b3;
            byte b2;
            byte b1;
            byte d4;
            byte d3;
            byte d2;
            byte d1;
            int i;
            if (encoded == null) {
                return null;
            }
            int len = Base64URL.removeWhiteSpace(encoded);
            if (len % 4 != 0) {
                return null;
            }
            int numberQuadruple = len / 4;
            if (numberQuadruple == 0) {
                return new byte[0];
            }
            int encodedIndex = 0;
            int dataIndex = 0;
            byte[] decodedData = new byte[numberQuadruple * 3];
            for (i = 0; i < numberQuadruple - 1; ++i) {
                if (!(Base64URL.isData(d1 = encoded[dataIndex++]) && Base64URL.isData(d2 = encoded[dataIndex++]) && Base64URL.isData(d3 = encoded[dataIndex++]) && Base64URL.isData(d4 = encoded[dataIndex++]))) {
                    return null;
                }
                b1 = base64Alphabet[d1];
                b2 = base64Alphabet[d2];
                b3 = base64Alphabet[d3];
                b4 = base64Alphabet[d4];
                decodedData[encodedIndex++] = (byte)(b1 << 2 | b2 >> 4);
                decodedData[encodedIndex++] = (byte)((b2 & 0xF) << 4 | b3 >> 2 & 0xF);
                decodedData[encodedIndex++] = (byte)(b3 << 6 | b4);
            }
            if (!Base64URL.isData(d1 = encoded[dataIndex++]) || !Base64URL.isData(d2 = encoded[dataIndex++])) {
                return null;
            }
            b1 = base64Alphabet[d1];
            b2 = base64Alphabet[d2];
            d3 = encoded[dataIndex++];
            d4 = encoded[dataIndex];
            if (!Base64URL.isData(d3) || !Base64URL.isData(d4)) {
                if (Base64URL.isPad(d3) && Base64URL.isPad(d4)) {
                    if ((b2 & 0xF) != 0) {
                        return null;
                    }
                    byte[] tmp = new byte[i * 3 + 1];
                    System.arraycopy(decodedData, 0, tmp, 0, i * 3);
                    tmp[encodedIndex] = (byte)(b1 << 2 | b2 >> 4);
                    return tmp;
                }
                if (!Base64URL.isPad(d3) && Base64URL.isPad(d4)) {
                    b3 = base64Alphabet[d3];
                    if ((b3 & 3) != 0) {
                        return null;
                    }
                    byte[] tmp = new byte[i * 3 + 2];
                    System.arraycopy(decodedData, 0, tmp, 0, i * 3);
                    tmp[encodedIndex++] = (byte)(b1 << 2 | b2 >> 4);
                    tmp[encodedIndex] = (byte)((b2 & 0xF) << 4 | b3 >> 2 & 0xF);
                    return tmp;
                }
                return null;
            }
            b3 = base64Alphabet[d3];
            b4 = base64Alphabet[d4];
            decodedData[encodedIndex++] = (byte)(b1 << 2 | b2 >> 4);
            decodedData[encodedIndex++] = (byte)((b2 & 0xF) << 4 | b3 >> 2 & 0xF);
            decodedData[encodedIndex] = (byte)(b3 << 6 | b4);
            return decodedData;
        }
    }
}

